/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.starteam;

import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Status;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.starteam.TreeBasedTask;

public class StarTeamCheckout
extends TreeBasedTask {
    private boolean createDirs = true;
    private boolean deleteUncontrolled = true;
    private boolean convertEOL = true;
    private int lockStatus = 3;
    private boolean useRepositoryTimeStamp = false;

    public void setCreateWorkingDirs(boolean value) {
        this.createDirs = value;
    }

    public void setDeleteUncontrolled(boolean value) {
        this.deleteUncontrolled = value;
    }

    public void setConvertEOL(boolean value) {
        this.convertEOL = value;
    }

    public void setLabel(String label) {
        this._setLabel(label);
    }

    public void setLocked(boolean v) throws BuildException {
        this.setLockStatus(v, 1);
    }

    public void setUnlocked(boolean v) throws BuildException {
        this.setLockStatus(v, 0);
    }

    private void setLockStatus(boolean v, int newStatus) throws BuildException {
        if (v) {
            if (this.lockStatus == 3) {
                this.lockStatus = newStatus;
            } else if (this.lockStatus != newStatus) {
                throw new BuildException("Error: cannot set locked and unlocked both true.");
            }
        }
    }

    public void setUseRepositoryTimeStamp(boolean useRepositoryTimeStamp) {
        this.useRepositoryTimeStamp = useRepositoryTimeStamp;
    }

    public boolean getUseRepositoryTimeStamp() {
        return this.useRepositoryTimeStamp;
    }

    public void setAsOfDate(String asOfDateParam) {
        this._setAsOfDate(asOfDateParam);
    }

    public void setAsOfDateFormat(String asOfDateFormat) {
        this._setAsOfDateFormat(asOfDateFormat);
    }

    protected View createSnapshotView(View raw) throws BuildException {
        int labelID = this.getLabelID(raw);
        if (this.isUsingViewLabel()) {
            return new View(raw, ViewConfiguration.createFromLabel((int)labelID));
        }
        if (this.isUsingRevisionLabel()) {
            return raw;
        }
        View view = this.getViewConfiguredByDate(raw);
        if (view != null) {
            return view;
        }
        return new View(raw, ViewConfiguration.createTip());
    }

    protected void testPreconditions() throws BuildException {
        if (this.isUsingRevisionLabel() && this.createDirs) {
            this.log("Ignoring createworkingdirs while using a revision label.  Folders will be created only as needed.", 1);
            this.createDirs = false;
        }
        if (this.lockStatus != 3) {
            boolean lockStatusBad = false;
            if (null != this.getLabel()) {
                this.log("Neither locked nor unlocked may be true when checking out a labeled version.", 0);
                lockStatusBad = true;
            } else if (null != this.getAsOfDate()) {
                this.log("Neither locked nor unlocked may be true when checking out by date.", 0);
                lockStatusBad = true;
            }
            if (lockStatusBad) {
                throw new BuildException("Lock status may not be changed when checking out a non-current version.");
            }
        }
        if (null != this.getLabel() && null != this.getAsOfDate()) {
            throw new BuildException("Both label and asOfDate specified.  Unable to process request.");
        }
    }

    protected void logOperationDescription(Folder starteamrootFolder, File targetrootFolder) {
        this.log((this.isRecursive() ? "Recursive" : "Non-recursive") + " Checkout from: " + starteamrootFolder.getFolderHierarchy());
        this.log("  Checking out to" + (null == this.getRootLocalFolder() ? "(default): " : ": ") + targetrootFolder.getAbsolutePath());
        this.logLabel();
        this.logAsOfDate();
        this.logIncludes();
        this.logExcludes();
        if (this.lockStatus == 1) {
            this.log("  Items will be checked out with Exclusive locks.");
        } else if (this.lockStatus == 0) {
            this.log("  Items will be checked out unlocked (even if presently locked).");
        } else {
            this.log("  Items will be checked out with no change in lock status.");
        }
        this.log("  Items will be checked out with " + (this.useRepositoryTimeStamp ? "repository timestamps." : "the current timestamp."));
        this.log("  Items will be checked out " + (this.isForced() ? "regardless of" : "in accordance with") + " repository status.");
        if (this.deleteUncontrolled) {
            this.log("  Local items not found in the repository will be deleted.");
        }
        this.log("  Items will be checked out " + (this.convertEOL ? "using the local machine's EOL convention" : "without changing the EOL convention used on the server"));
        this.log("  Directories will be created" + (this.createDirs ? " wherever they exist in the repository, even if empty." : " only where needed to check out files."));
    }

    protected void visit(Folder starteamFolder, File targetFolder) throws BuildException {
        try {
            int i;
            if (null != this.getRootLocalFolder()) {
                starteamFolder.setAlternatePathFragment(targetFolder.getAbsolutePath());
            }
            if (!targetFolder.exists() && !this.isUsingRevisionLabel() && this.createDirs) {
                if (targetFolder.mkdirs()) {
                    this.log("Creating folder: " + targetFolder);
                } else {
                    throw new BuildException("Failed to create local folder " + targetFolder);
                }
            }
            Folder[] foldersList = starteamFolder.getSubFolders();
            Item[] filesList = starteamFolder.getItems(this.getTypeNames().FILE);
            if (this.isUsingRevisionLabel()) {
                Hashtable<Integer, Integer> labelItems = new Hashtable<Integer, Integer>(filesList.length);
                int s = filesList.length;
                int[] ids = new int[s];
                for (int i2 = 0; i2 < s; ++i2) {
                    ids[i2] = filesList[i2].getItemID();
                    labelItems.put(new Integer(ids[i2]), new Integer(i2));
                }
                int[] foundIds = this.getLabelInUse().getLabeledItemIDs(ids);
                s = foundIds.length;
                Item[] labeledFiles = new Item[s];
                for (int i3 = 0; i3 < s; ++i3) {
                    Integer id = new Integer(foundIds[i3]);
                    labeledFiles[i3] = filesList[(Integer)labelItems.get(id)];
                }
                filesList = labeledFiles;
            }
            TreeBasedTask.UnmatchedFileMap ufm = new CheckoutMap().init(targetFolder.getAbsoluteFile(), starteamFolder);
            for (i = 0; i < foldersList.length; ++i) {
                Folder stFolder = foldersList[i];
                File subfolder = new File(targetFolder, stFolder.getName());
                ufm.removeControlledItem(subfolder);
                if (!this.isRecursive()) continue;
                this.visit(stFolder, subfolder);
            }
            for (i = 0; i < filesList.length; ++i) {
                com.starbase.starteam.File stFile = (com.starbase.starteam.File)filesList[i];
                this.processFile(stFile, targetFolder);
                ufm.removeControlledItem(new File(targetFolder, stFile.getName()));
            }
            if (this.deleteUncontrolled) {
                ufm.processUncontrolledItems();
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String describeCheckout(com.starbase.starteam.File remotefile, File localFile) {
        StringBuffer sb = new StringBuffer();
        sb.append(StarTeamCheckout.getFullRepositoryPath(remotefile)).append(" --> ");
        if (null == localFile) {
            sb.append(remotefile.getFullName());
        } else {
            sb.append(localFile);
        }
        return sb.toString();
    }

    private String describeCheckout(com.starbase.starteam.File remotefile) {
        return this.describeCheckout(remotefile, null);
    }

    private void processFile(com.starbase.starteam.File eachFile, File targetFolder) throws IOException {
        String filename = eachFile.getName();
        File localFile = new File(targetFolder, filename);
        if (!this.shouldProcess(filename)) {
            this.log("Excluding " + StarTeamCheckout.getFullRepositoryPath(eachFile), 2);
            return;
        }
        if (this.isUsingRevisionLabel()) {
            boolean success;
            if (!targetFolder.exists()) {
                if (targetFolder.mkdirs()) {
                    this.log("Creating folder: " + targetFolder);
                } else {
                    throw new BuildException("Failed to create local folder " + targetFolder);
                }
            }
            if (success = eachFile.checkoutByLabelID(localFile, this.getIDofLabelInUse(), this.lockStatus, !this.useRepositoryTimeStamp, true, false)) {
                this.log("Checked out " + this.describeCheckout(eachFile, localFile));
            }
        } else {
            boolean checkout = true;
            int fileStatus = eachFile.getStatus();
            if (fileStatus == 1 || fileStatus == 6) {
                eachFile.updateStatus(true, true);
                fileStatus = eachFile.getStatus();
            }
            this.log(eachFile.toString() + " has status of " + Status.name((int)fileStatus), 4);
            switch (fileStatus) {
                case 2: 
                case 5: {
                    this.log("Checking out: " + this.describeCheckout(eachFile));
                    break;
                }
                default: {
                    if (this.isForced() && fileStatus != 0) {
                        this.log("Forced checkout of " + this.describeCheckout(eachFile) + " over status " + Status.name((int)fileStatus));
                        break;
                    }
                    this.log("Skipping: " + StarTeamCheckout.getFullRepositoryPath(eachFile) + " - status: " + Status.name((int)fileStatus));
                    checkout = false;
                }
            }
            if (checkout) {
                if (!targetFolder.exists()) {
                    if (targetFolder.mkdirs()) {
                        this.log("Creating folder: " + targetFolder);
                    } else {
                        throw new BuildException("Failed to create local folder " + targetFolder);
                    }
                }
                eachFile.checkout(this.lockStatus, !this.useRepositoryTimeStamp, this.convertEOL, false);
            }
        }
    }

    private class CheckoutMap
    extends TreeBasedTask.UnmatchedFileMap {
        private CheckoutMap() {
            super(StarTeamCheckout.this);
        }

        protected boolean isActive() {
            return StarTeamCheckout.this.deleteUncontrolled;
        }

        TreeBasedTask.UnmatchedFileMap init(File localFolder, Folder remoteFolder) {
            if (!localFolder.exists()) {
                return this;
            }
            String[] localFiles = localFolder.list();
            if (localFiles == null) {
                return this;
            }
            for (int i = 0; i < localFiles.length; ++i) {
                File localFile = new File(localFolder, localFiles[i]).getAbsoluteFile();
                StarTeamCheckout.this.log("adding " + localFile + " to UnmatchedFileMap", 4);
                if (localFile.isDirectory()) {
                    this.put(localFile, "");
                    continue;
                }
                this.put(localFile, "");
            }
            return this;
        }

        void processUncontrolledItems() throws BuildException {
            if (this.isActive()) {
                Enumeration e = this.keys();
                while (e.hasMoreElements()) {
                    File local = (File)e.nextElement();
                    this.delete(local);
                }
            }
        }

        void delete(File local) {
            if (local.isDirectory() && StarTeamCheckout.this.isRecursive()) {
                String[] contents = local.list();
                for (int i = 0; i < contents.length; ++i) {
                    File file = new File(local, contents[i]);
                    this.delete(file);
                }
            }
            local.delete();
            StarTeamCheckout.this.log("Deleted uncontrolled item " + local.getAbsolutePath());
        }
    }
}

