/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.updates;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.p2.ui.sdk.StatusLineCLabelContribution;
import org.eclipse.equinox.internal.p2.ui.sdk.updates.AutomaticUpdatesPopup;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProfileEvent;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.ui.IProfileChooser;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.UpdateAction;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.DownloadPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProfileModificationOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IPlanValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policies;
import org.eclipse.equinox.internal.provisional.p2.ui.query.ElementQueryDescriptor;
import org.eclipse.equinox.internal.provisional.p2.ui.sdk.ProvPolicies;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateListener;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.UpdateEvent;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class AutomaticUpdater
implements IUpdateListener {
    Preferences prefs = ProvSDKUIActivator.getDefault().getPluginPreferences();
    StatusLineCLabelContribution updateAffordance;
    AutomaticUpdateAction updateAction;
    IStatusLineManager statusLineManager;
    IInstallableUnit[] iusWithUpdates;
    String profileId;
    AutomaticUpdatesPopup popup;
    ProvisioningListener profileChangeListener;
    IJobChangeListener provisioningJobListener;
    boolean alreadyValidated = false;
    boolean alreadyDownloaded = false;
    private static final String AUTO_UPDATE_STATUS_ITEM = "AutoUpdatesStatus";
    static /* synthetic */ Class class$0;

    public void updatesAvailable(UpdateEvent event) {
        block9: {
            boolean download = this.prefs.getBoolean("download");
            this.profileId = event.getProfileId();
            this.iusWithUpdates = event.getIUs();
            this.validateUpdates(null, true);
            this.alreadyDownloaded = false;
            if (this.iusWithUpdates.length <= 0) {
                this.clearUpdatesAvailable();
                return;
            }
            this.registerProfileChangeListener();
            this.registerProvisioningJobListener();
            try {
                if (download) {
                    IInstallableUnit[] replacements;
                    ElementQueryDescriptor descriptor = ProvSDKUIActivator.getDefault().getQueryProvider().getQueryDescriptor((Object)event, 5);
                    Collector collector = descriptor.queryable.query(descriptor.query, descriptor.collector, null);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((replacements = (IInstallableUnit[])collector.toArray((Class)clazz)).length > 0) {
                        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((String)event.getProfileId());
                        request.removeInstallableUnits(this.iusWithUpdates);
                        request.addInstallableUnits(replacements);
                        ProvisioningPlan plan = ProvisioningUtil.getPlanner().getProvisioningPlan(request, new ProvisioningContext(), null);
                        Job job = ProvisioningOperationRunner.schedule((ProvisioningOperation)new ProfileModificationOperation(ProvSDKMessages.AutomaticUpdater_AutomaticDownloadOperationName, event.getProfileId(), plan, (PhaseSet)new DownloadPhaseSet(), false), null, (int)1);
                        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent jobEvent) {
                                AutomaticUpdater.this.alreadyDownloaded = true;
                                IStatus status = jobEvent.getResult();
                                if (status.isOK()) {
                                    AutomaticUpdater.this.createUpdateAction();
                                    AutomaticUpdater.this.updateAction.initializePlan();
                                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this){
                                        final /* synthetic */ 2 this$1;
                                        {
                                            this.this$1 = var1_1;
                                        }

                                        public void run() {
                                            2.access$0(this.this$1).updateAction.run();
                                        }
                                    });
                                } else if (status.getSeverity() != 8) {
                                    ProvUI.reportStatus((IStatus)status, (int)1);
                                }
                            }

                            static /* synthetic */ AutomaticUpdater access$0(2 var0) {
                                return var0.AutomaticUpdater.this;
                            }
                        });
                    }
                    break block9;
                }
                this.createUpdateAction();
                this.updateAction.initializePlan();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        AutomaticUpdater.this.updateAction.run();
                    }
                });
            }
            catch (ProvisionException e) {
                ProvUI.handleException((Throwable)e, (String)ProvSDKMessages.AutomaticUpdater_ErrorCheckingUpdates, (int)1);
            }
        }
    }

    void validateUpdates(IProgressMonitor monitor, boolean isKnownToBeAvailable) {
        ArrayList<IInstallableUnit> list = new ArrayList<IInstallableUnit>();
        int i = 0;
        while (i < this.iusWithUpdates.length) {
            try {
                if ((isKnownToBeAvailable || ProvisioningUtil.getPlanner().updatesFor(this.iusWithUpdates[i], new ProvisioningContext(), monitor).length > 0) && this.validToUpdate(this.iusWithUpdates[i])) {
                    list.add(this.iusWithUpdates[i]);
                }
            }
            catch (ProvisionException e) {
                ProvUI.handleException((Throwable)e, (String)ProvSDKMessages.AutomaticUpdater_ErrorCheckingUpdates, (int)1);
            }
            ++i;
        }
        this.iusWithUpdates = list.toArray(new IInstallableUnit[list.size()]);
    }

    private boolean validToUpdate(IInstallableUnit iu) {
        int lock = 0;
        boolean isRoot = false;
        try {
            IProfile profile = ProvisioningUtil.getProfile((String)this.profileId);
            String value = profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.lock");
            if (value != null) {
                lock = Integer.parseInt(value);
            }
            isRoot = (value = profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.root")) == null ? false : Boolean.valueOf(value);
        }
        catch (ProvisionException provisionException) {
        }
        catch (NumberFormatException numberFormatException) {}
        return isRoot && (lock & 2) == 0;
    }

    Shell getWorkbenchWindowShell() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return activeWindow != null ? activeWindow.getShell() : null;
    }

    IStatusLineManager getStatusLineManager() {
        if (this.statusLineManager != null) {
            return this.statusLineManager;
        }
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return null;
        }
        try {
            Method method = activeWindow.getClass().getDeclaredMethod("getStatusLineManager", new Class[0]);
            try {
                Object statusLine = method.invoke((Object)activeWindow, new Object[0]);
                if (statusLine instanceof IStatusLineManager) {
                    this.statusLineManager = (IStatusLineManager)statusLine;
                    return this.statusLineManager;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        IWorkbenchPartSite site = activeWindow.getActivePage().getActivePart().getSite();
        if (site instanceof IViewSite) {
            this.statusLineManager = ((IViewSite)site).getActionBars().getStatusLineManager();
        } else if (site instanceof IEditorSite) {
            this.statusLineManager = ((IEditorSite)site).getActionBars().getStatusLineManager();
        }
        return this.statusLineManager;
    }

    void updateStatusLine() {
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            manager.update(true);
        }
    }

    void createUpdateAffordance() {
        this.updateAffordance = new StatusLineCLabelContribution(AUTO_UPDATE_STATUS_ITEM, 5);
        this.updateAffordance.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                AutomaticUpdater.this.launchUpdate();
            }
        });
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            manager.add((IContributionItem)this.updateAffordance);
            manager.update(true);
        }
    }

    void setUpdateAffordanceState(boolean isValid) {
        if (this.updateAffordance == null) {
            return;
        }
        if (isValid) {
            this.updateAffordance.setTooltip(ProvSDKMessages.AutomaticUpdater_ClickToReviewUpdates);
            this.updateAffordance.setImage(ProvUIImages.getImage((String)"tool/update.gif"));
        } else {
            this.updateAffordance.setTooltip(ProvSDKMessages.AutomaticUpdater_ClickToReviewUpdatesWithProblems);
            this.updateAffordance.setImage(ProvUIImages.getImage((String)"tool/update_problems.gif"));
        }
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            manager.update(true);
        }
    }

    void checkUpdateAffordanceEnablement() {
        IStatusLineManager manager;
        boolean shouldBeVisible;
        if (this.updateAffordance == null) {
            return;
        }
        boolean bl = shouldBeVisible = !ProvisioningOperationRunner.hasScheduledOperations();
        if (this.updateAffordance.isVisible() != shouldBeVisible && (manager = this.getStatusLineManager()) != null) {
            this.updateAffordance.setVisible(shouldBeVisible);
            manager.update(true);
        }
    }

    void createUpdatePopup() {
        this.popup = new AutomaticUpdatesPopup(this.getWorkbenchWindowShell(), this.alreadyDownloaded, this.prefs);
        this.popup.open();
    }

    void createUpdateAction() {
        if (this.updateAction == null) {
            this.updateAction = new AutomaticUpdateAction(this.getSelectionProvider(), this.profileId, null, ProvPolicies.getDefault(), null);
        }
    }

    void clearUpdatesAvailable() {
        if (this.updateAffordance != null) {
            IStatusLineManager manager = this.getStatusLineManager();
            if (manager != null) {
                manager.remove((IContributionItem)this.updateAffordance);
                manager.update(true);
            }
            this.updateAffordance.dispose();
            this.updateAffordance = null;
        }
        if (this.popup != null) {
            this.popup.close(false);
            this.popup = null;
        }
        this.alreadyValidated = false;
    }

    ISelectionProvider getSelectionProvider() {
        return new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return new StructuredSelection((Object[])AutomaticUpdater.this.iusWithUpdates);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection sel) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }
        };
    }

    public void launchUpdate() {
        this.alreadyValidated = true;
        this.updateAction.run();
    }

    private void registerProfileChangeListener() {
        if (this.profileChangeListener == null) {
            this.profileChangeListener = new ProvisioningListener(){

                public void notify(EventObject o) {
                    ProfileEvent event;
                    if (o instanceof ProfileEvent && (event = (ProfileEvent)o).getReason() == 2 && AutomaticUpdater.this.profileId.equals(event.getProfileId())) {
                        AutomaticUpdater.this.validateUpdates();
                    }
                }
            };
            IProvisioningEventBus bus = ProvSDKUIActivator.getDefault().getProvisioningEventBus();
            if (bus != null) {
                bus.addListener(this.profileChangeListener);
            }
        }
    }

    private void registerProvisioningJobListener() {
        if (this.provisioningJobListener == null) {
            this.provisioningJobListener = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    if (workbench == null || workbench.isClosing()) {
                        return;
                    }
                    if (workbench.getDisplay() == null) {
                        return;
                    }
                    workbench.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            8.access$0(this.this$1).checkUpdateAffordanceEnablement();
                        }
                    });
                }

                public void scheduled(IJobChangeEvent event) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    if (workbench == null || workbench.isClosing()) {
                        return;
                    }
                    if (workbench.getDisplay() == null) {
                        return;
                    }
                    workbench.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            8.access$0(this.this$1).checkUpdateAffordanceEnablement();
                        }
                    });
                }

                static /* synthetic */ AutomaticUpdater access$0(8 var0) {
                    return var0.AutomaticUpdater.this;
                }
            };
            ProvisioningOperationRunner.addJobChangeListener((IJobChangeListener)this.provisioningJobListener);
        }
    }

    void validateUpdates() {
        WorkbenchJob validateJob = new WorkbenchJob("Update validate job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                AutomaticUpdater.this.validateUpdates(monitor, false);
                if (AutomaticUpdater.this.iusWithUpdates.length == 0) {
                    AutomaticUpdater.this.clearUpdatesAvailable();
                } else {
                    AutomaticUpdater.this.createUpdateAction();
                    AutomaticUpdater.this.updateAction.initializePlan();
                    AutomaticUpdater.this.setUpdateAffordanceState(AutomaticUpdater.this.updateAction.getProvisioningPlan(AutomaticUpdater.this.iusWithUpdates).getStatus().isOK());
                }
                return Status.OK_STATUS;
            }
        };
        validateJob.setSystem(true);
        validateJob.setPriority(20);
        validateJob.schedule();
    }

    public void shutdown() {
        if (this.provisioningJobListener != null) {
            ProvisioningOperationRunner.removeJobChangeListener((IJobChangeListener)this.provisioningJobListener);
            this.provisioningJobListener = null;
        }
        if (this.profileChangeListener == null) {
            return;
        }
        IProvisioningEventBus bus = ProvSDKUIActivator.getDefault().getProvisioningEventBus();
        if (bus != null) {
            bus.removeListener(this.profileChangeListener);
        }
        this.profileChangeListener = null;
        this.statusLineManager = null;
    }

    final class AutomaticUpdateAction
    extends UpdateAction {
        ProvisioningPlan currentPlan;

        AutomaticUpdateAction(ISelectionProvider selectionProvider, String profileId, IProfileChooser chooser, Policies policies, Shell shell) {
            super(selectionProvider, profileId, chooser, policies, shell);
        }

        public void initializePlan() {
            try {
                this.currentPlan = this.getProvisioningPlan(AutomaticUpdater.this.iusWithUpdates, AutomaticUpdater.this.profileId, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ProvisionException provisionException) {}
        }

        protected ProvisioningPlan getProvisioningPlan(IInstallableUnit[] ius) {
            if (this.currentPlan != null) {
                return this.currentPlan;
            }
            return super.getProvisioningPlan(ius);
        }

        protected IPlanValidator getPlanValidator() {
            return new IPlanValidator(this){
                final /* synthetic */ AutomaticUpdateAction this$1;
                {
                    this.this$1 = automaticUpdateAction;
                }

                public boolean continueWorkingWithPlan(ProvisioningPlan plan, Shell shell) {
                    if (AutomaticUpdateAction.access$0((AutomaticUpdateAction)this.this$1).alreadyValidated) {
                        return true;
                    }
                    String openPlan = AutomaticUpdateAction.access$0((AutomaticUpdateAction)this.this$1).prefs.getString("allowNonOKPlan");
                    if (plan != null) {
                        boolean noError;
                        if (plan.getStatus().getSeverity() == 8) {
                            return false;
                        }
                        boolean bl = noError = plan.getStatus().getSeverity() != 4;
                        if (noError || !"never".equals(openPlan)) {
                            if (AutomaticUpdateAction.access$0((AutomaticUpdateAction)this.this$1).updateAffordance == null) {
                                AutomaticUpdateAction.access$0(this.this$1).createUpdateAffordance();
                            }
                            AutomaticUpdateAction.access$0(this.this$1).setUpdateAffordanceState(noError);
                            if ((noError || "always".equals(openPlan)) && AutomaticUpdateAction.access$0((AutomaticUpdateAction)this.this$1).popup == null) {
                                AutomaticUpdateAction.access$0(this.this$1).createUpdatePopup();
                            }
                        } else {
                            ProvUI.reportStatus((IStatus)plan.getStatus(), (int)1);
                        }
                    }
                    return false;
                }
            };
        }

        static /* synthetic */ AutomaticUpdater access$0(AutomaticUpdateAction automaticUpdateAction) {
            return automaticUpdateAction.AutomaticUpdater.this;
        }
    }
}

