/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core;

import edu.mit.story.core.IdentifiedPlugin;
import edu.mit.story.core.agreement.AgreementCalculatorManager;
import edu.mit.story.core.build.BuildRuleManager;
import edu.mit.story.core.build.IBuildRuleManager;
import edu.mit.story.core.desc.factory.FactoryManager;
import edu.mit.story.core.desc.factory.IFactoryManager;
import edu.mit.story.core.merge.IMergeProfileManager;
import edu.mit.story.core.merge.MergeProfileManager;
import edu.mit.story.core.meta.IMetaRepManager;
import edu.mit.story.core.meta.MetaRepManager;
import edu.mit.story.core.property.ConfigurationManager;
import edu.mit.story.core.property.IConfigurationManager;
import edu.mit.story.core.rep.IRepManager;
import edu.mit.story.core.rep.RepManager;
import org.osgi.framework.BundleContext;

public final class StoryPlugin
extends IdentifiedPlugin {
    public static final String ID = "edu.mit.story.core";
    public static final String MARKER_ID_STORY = "edu.mit.story.core.marker.story";
    private static StoryPlugin instance;
    private IRepManager repManager;
    private IMetaRepManager metaRepManager;
    private IFactoryManager factoryManager;
    private IConfigurationManager configManager;
    private IBuildRuleManager ruleManager;
    private IMergeProfileManager profileManager;

    public static StoryPlugin getDefault() {
        return instance;
    }

    public StoryPlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        AgreementCalculatorManager.getInstance();
    }

    public IMetaRepManager getMetaRepManager() {
        if (this.metaRepManager == null) {
            this.metaRepManager = new MetaRepManager();
            this.metaRepManager.init();
        }
        return this.metaRepManager;
    }

    public IRepManager getRepManager() {
        if (this.repManager == null) {
            this.repManager = new RepManager();
            this.repManager.init();
        }
        return this.repManager;
    }

    public IFactoryManager getFactoryManager() {
        if (this.factoryManager == null) {
            this.factoryManager = new FactoryManager();
            this.factoryManager.init();
        }
        return this.factoryManager;
    }

    public IConfigurationManager getConfigurationManager() {
        if (this.configManager == null) {
            this.configManager = new ConfigurationManager();
            this.configManager.init();
        }
        return this.configManager;
    }

    public IBuildRuleManager getBuildRuleManager() {
        if (this.ruleManager == null) {
            this.ruleManager = new BuildRuleManager();
            this.ruleManager.init();
        }
        return this.ruleManager;
    }

    public IMergeProfileManager getMergeProfileManager() {
        if (this.profileManager == null) {
            this.profileManager = new MergeProfileManager();
            this.profileManager.init();
        }
        return this.profileManager;
    }
}

