/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.agreement;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.agreement.AgreementCalculatorDescriptor;
import edu.mit.story.core.agreement.IAgreeCalcDescriptor;
import edu.mit.story.core.agreement.IAgreementCalculator;
import edu.mit.story.core.agreement.IAgreementCalculatorManager;
import edu.mit.story.core.manager.CreatableManager;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgreementCalculatorManager
extends CreatableManager<IAgreementCalculator, IAgreeCalcDescriptor>
implements IAgreementCalculatorManager {
    private static IAgreementCalculatorManager instance;
    private static final Lock instanceLock;
    protected List<IAgreeCalcDescriptor> allList;
    protected Map<IRep, List<IAgreeCalcDescriptor>> repMap;

    static {
        instanceLock = new ReentrantLock();
    }

    public static void setInstance(IAgreementCalculatorManager m) {
        if (m == null) {
            throw new NullPointerException();
        }
        try {
            instanceLock.lock();
            if (instance != null) {
                throw new IllegalStateException("Manager already set");
            }
            instance = m;
        }
        finally {
            instanceLock.unlock();
        }
    }

    public static IAgreementCalculatorManager getInstance() {
        if (instance == null) {
            try {
                instanceLock.lock();
                if (instance == null) {
                    instance = new AgreementCalculatorManager();
                    instance.init();
                }
            }
            finally {
                instanceLock.unlock();
            }
        }
        return instance;
    }

    protected boolean registerDescriptor(IAgreeCalcDescriptor desc, Multimap<IRep, IAgreeCalcDescriptor> map) {
        boolean success = this.registerDescriptor(desc);
        if (!success) {
            return success;
        }
        IRepSet reps = desc.getReps();
        if (reps.isEmpty()) {
            map.put(null, (Object)desc);
        } else {
            for (IRep rep : reps) {
                map.put((Object)rep, (Object)desc);
            }
        }
        return true;
    }

    @Override
    protected boolean doInit() {
        ArrayList list;
        LinkedListMultimap repsToDescs = LinkedListMultimap.create();
        for (IConfigurationElement element : AgreementCalculatorManager.getElements("edu.mit.story.core.agreementCalculators", "agreementCalculator")) {
            AgreementCalculatorDescriptor d = new AgreementCalculatorDescriptor(element);
            try {
                this.registerDescriptor(d, (Multimap<IRep, IAgreeCalcDescriptor>)repsToDescs);
            }
            catch (Exception e) {
                Status status = new Status(4, element.getContributor().getName(), "Problem with agreement calculator extension", (Throwable)e);
                StoryPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        Comparator<IAgreeCalcDescriptor> c = new Comparator<IAgreeCalcDescriptor>(){

            @Override
            public int compare(IAgreeCalcDescriptor d1, IAgreeCalcDescriptor d2) {
                return d1.getID().compareTo(d2.getID());
            }
        };
        Map repToDescMap = repsToDescs.asMap();
        List allList = (List)repToDescMap.remove(null);
        TreeMap repMap = new TreeMap();
        for (Map.Entry e : repToDescMap.entrySet()) {
            list = new ArrayList((Collection)e.getValue());
            Collections.sort(list, c);
            repMap.put((IRep)e.getKey(), Collections.unmodifiableList(list));
        }
        list = new ArrayList(allList);
        Collections.sort(list, c);
        this.repMap = Collections.unmodifiableMap(repMap);
        this.allList = Collections.unmodifiableList(list);
        return true;
    }

    @Override
    public List<IAgreeCalcDescriptor> getDescriptors(Set<IRep> reps) {
        if (reps == null || reps.isEmpty()) {
            return this.allList;
        }
        ArrayList<IAgreeCalcDescriptor> result = new ArrayList<IAgreeCalcDescriptor>();
        result.addAll(this.allList);
        for (IRep rep : reps) {
            List<IAgreeCalcDescriptor> repDescs = this.repMap.get(rep);
            if (repDescs == null) continue;
            result.addAll(repDescs);
        }
        return result;
    }

    @Override
    public List<IAgreeCalcDescriptor> getDescriptors(IRep rep) {
        if (rep == null) {
            return this.allList;
        }
        return this.getDescriptors(Collections.singleton(rep));
    }
}

