/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.align;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Aligner<A, B> {
    public int gapPenalty = -1;

    public void setGapPenalty(int penalty) {
        this.gapPenalty = penalty;
    }

    public List<Pair<A, B>> align(List<A> as, List<B> bs) {
        int gapPenalty = this.gapPenalty;
        int[][] fMatrix = this.computeFMatrix(as, bs, gapPenalty);
        LinkedList<Pair<A, B>> result = new LinkedList<Pair<A, B>>();
        int i = as.size();
        int j = bs.size();
        while (i > 0 && j > 0) {
            int score = fMatrix[i][j];
            int scoreDiag = fMatrix[i - 1][j - 1];
            int scoreUp = fMatrix[i][j - 1];
            int scoreLeft = fMatrix[i - 1][j];
            if (score == scoreDiag + this.sim(as.get(i - 1), bs.get(j - 1))) {
                result.addFirst(new Pair<A, B>(as.get(i - 1), bs.get(j - 1)));
                --i;
                --j;
                continue;
            }
            if (score == scoreLeft + gapPenalty) {
                result.addFirst(new Pair<A, Object>(as.get(i - 1), null));
                --i;
                continue;
            }
            if (score != scoreUp + gapPenalty) continue;
            result.addFirst(new Pair<Object, B>(null, bs.get(j - 1)));
            --j;
        }
        while (i > 0) {
            result.addFirst(new Pair<A, Object>(as.get(i - 1), null));
            --i;
        }
        while (j > 0) {
            result.addFirst(new Pair<Object, B>(null, bs.get(j - 1)));
            --j;
        }
        return result;
    }

    public int[][] computeFMatrix(List<A> as, List<B> bs, int d) {
        int[][] fMatrix = new int[as.size() + 1][bs.size() + 1];
        int i = 0;
        while (i < as.size()) {
            fMatrix[i][0] = d * i;
            ++i;
        }
        int j = 0;
        while (j < bs.size()) {
            fMatrix[0][j] = d * j;
            ++j;
        }
        int i2 = 1;
        while (i2 <= as.size()) {
            int j2 = 1;
            while (j2 <= bs.size()) {
                int c1 = fMatrix[i2 - 1][j2 - 1] + this.sim(as.get(i2 - 1), bs.get(j2 - 1));
                int c2 = fMatrix[i2 - 1][j2] + d;
                int c3 = fMatrix[i2][j2 - 1] + d;
                fMatrix[i2][j2] = Math.max(c1, Math.max(c2, c3));
                ++j2;
            }
            ++i2;
        }
        return fMatrix;
    }

    public abstract int sim(A var1, B var2);

    public static void main(String[] args) {
        Aligner<Character, Character> aligner = new Aligner<Character, Character>(){

            @Override
            public int sim(Character a, Character b) {
                return a.equals(b) ? 10 : 0;
            }
        };
        String strA = "AGACTAGTTAC";
        String strB = "BGATTTAC";
        ArrayList<Character> seqA = new ArrayList<Character>(strA.length());
        char[] cArray = strA.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            seqA.add(Character.valueOf(c));
            ++n2;
        }
        ArrayList<Character> seqB = new ArrayList<Character>(strB.length());
        char[] cArray2 = strB.toCharArray();
        int n3 = cArray2.length;
        n = 0;
        while (n < n3) {
            char c = cArray2[n];
            seqB.add(Character.valueOf(c));
            ++n;
        }
        List result = aligner.align(seqA, seqB);
        StringBuilder seqAalign = new StringBuilder(result.size());
        StringBuilder seqBalign = new StringBuilder(result.size());
        for (Pair pair : result) {
            seqAalign.append(pair.a == null ? (char)'-' : ((Character)pair.a).charValue());
            seqBalign.append(pair.b == null ? (char)'-' : ((Character)pair.b).charValue());
        }
        System.out.println(seqAalign);
        System.out.println(seqBalign);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<A, B> {
        public final A a;
        public final B b;

        public Pair(A a, B b) {
            if (a == null && b == null) {
                throw new IllegalArgumentException();
            }
            this.a = a;
            this.b = b;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.a);
            sb.append("=");
            sb.append(this.b);
            return sb.toString();
        }
    }
}

