/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.datamodel;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.datamodel.ITagModel;
import edu.mit.story.core.validation.Message;
import org.eclipse.jface.dialogs.IMessageProvider;

public class TagModel
extends AbstractViewModel
implements ITagModel {
    public static final Message srcTagNotEmpty = new Message("The source tag may not be empty or all whitespace", 3);
    public static final Message tgtTagNotEmpty = new Message("The target tag may not be empty or all whitespace", 3);
    private String targetTag = this.getDefaultTargetTag();
    private String sourceTag = this.getDefaultSourceTag();

    public void setSourceTag(String newTag) {
        if (Objects.equal((Object)this.sourceTag, (Object)(newTag = Strings.nullToEmpty((String)newTag)))) {
            return;
        }
        this.sourceTag = newTag;
        this.fireChanged();
    }

    public void setTargetTag(String newTag) {
        if (Objects.equal((Object)this.targetTag, (Object)(newTag = Strings.nullToEmpty((String)newTag)))) {
            return;
        }
        this.targetTag = newTag;
        this.fireChanged();
    }

    public String getSourceTag() {
        return this.sourceTag;
    }

    public String getTargetTag() {
        return this.targetTag;
    }

    protected String getDefaultSourceTag() {
        return "source";
    }

    protected String getDefaultTargetTag() {
        return "target";
    }

    protected void internalClear() {
        this.sourceTag = this.getDefaultSourceTag();
        this.targetTag = this.getDefaultTargetTag();
    }

    protected IMessageProvider calculateMessage() {
        if (Strings.isNullOrEmpty((String)Strings.nullToEmpty((String)this.sourceTag))) {
            return srcTagNotEmpty;
        }
        if (Strings.isNullOrEmpty((String)Strings.nullToEmpty((String)this.targetTag))) {
            return tgtTagNotEmpty;
        }
        return Message.NO_MESSAGE;
    }

    public boolean isCleared() {
        if (!Objects.equal((Object)this.sourceTag, (Object)this.getDefaultSourceTag())) {
            return false;
        }
        return Objects.equal((Object)this.targetTag, (Object)this.getDefaultTargetTag());
    }
}

