/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.mappers;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.core.mappers.IValueMapper;
import edu.mit.story.core.model.IStoryData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionMapper
implements IValueMapper<IDesc> {
    private static Pattern comma = Pattern.compile(",");
    IStoryData data;

    public DescriptionMapper(IStoryData data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = data;
    }

    @Override
    public List<IDesc> reconstitute(String value) {
        return DescriptionMapper.toObjectsStatic(value, this.data);
    }

    @Override
    public String serialize(Collection<? extends IDesc> objects) {
        return DescriptionMapper.toValueStatic(objects);
    }

    public static List<IDesc> toObjectsStatic(String value, IDescMultiSet data) {
        if (data == null || value == null) {
            return null;
        }
        String trimmed = value.trim();
        if (trimmed.length() == 0) {
            return null;
        }
        String[] ids = comma.split(trimmed);
        if (ids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                IDesc desc = data.getDescription(Long.parseLong(id));
                if (desc != null) {
                    result.add(desc);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            ++n2;
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    public static String toValueStatic(Collection<? extends IDesc> objects) {
        StringBuffer sb = new StringBuffer();
        if (objects != null) {
            Iterator<? extends IDesc> i = objects.iterator();
            while (i.hasNext()) {
                IDesc entry = i.next();
                sb.append(entry.getID());
                if (!i.hasNext()) continue;
                sb.append(',');
            }
        }
        return sb.toString();
    }
}

