/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.measure;

import edu.mit.story.core.measure.IPairExtractor;
import edu.mit.story.core.measure.IResult;
import edu.mit.story.core.measure.ITargetExtractor;
import edu.mit.story.core.measure.Result;
import edu.mit.story.core.measure.StoryFileExtractor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryPairExtractor
implements IPairExtractor<IFile> {
    private static StoryPairExtractor instance = null;
    private ITargetExtractor<IFile> extractor;

    public static StoryPairExtractor getInstance() {
        if (instance == null) {
            instance = new StoryPairExtractor(StoryFileExtractor.getInstance());
        }
        return instance;
    }

    public StoryPairExtractor(ITargetExtractor<IFile> extractor) {
        if (extractor == null) {
            throw new NullPointerException();
        }
        this.extractor = extractor;
    }

    @Override
    public Map<IFile, IFile> getPairs(IResource topTarget, IResource topSource, List<IResult> results) {
        if (topTarget == null) {
            throw new NullPointerException();
        }
        if (topSource == null) {
            throw new NullPointerException();
        }
        if (results == null) {
            results = new LinkedList<IResult>();
        }
        List<IFile> targets = this.extractor.getTargets(topTarget, results);
        List<IFile> sources = this.extractor.getTargets(topSource, results);
        HashMap<String, IFile> sourceMap = new HashMap<String, IFile>();
        for (IFile source : sources) {
            sourceMap.put(source.getName(), source);
        }
        HashSet<Object> unpaired = new HashSet<Object>();
        LinkedHashMap<IFile, IFile> result = new LinkedHashMap<IFile, IFile>();
        for (IFile iFile : targets) {
            IFile source = (IFile)sourceMap.remove(iFile.getName());
            if (source == null) {
                unpaired.add(iFile);
                continue;
            }
            result.put(iFile, source);
        }
        unpaired.addAll(sourceMap.values());
        for (IFile iFile : unpaired) {
            results.add(new Result((IResource)iFile, "No file found to pair with", null));
        }
        return result;
    }

    protected IPath getIndexingPath(IFile file) {
        IPath path = file.getProjectRelativePath();
        String firstSegment = path.segment(0);
        if (firstSegment.equals("done") || firstSegment.equals("todo")) {
            path = path.removeFirstSegments(1);
        }
        return path;
    }
}

