/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.model.change.StoryChangeEventIntegrator;

public class ReplaceDescriptionChange
extends AbstractModelChange {
    private final IDesc oldDesc;
    private final IDesc newDesc;

    public ReplaceDescriptionChange(String name, IDesc oldDesc, IDesc newDesc) {
        super(name);
        if (oldDesc == null) {
            throw new NullPointerException();
        }
        if (newDesc == null) {
            throw new NullPointerException();
        }
        this.oldDesc = oldDesc;
        this.newDesc = newDesc;
    }

    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        AbstractModelChange change = new RemoveDescriptionsChange(this.oldDesc);
        StoryChangeEvent event = change.apply(source, model);
        if (event == null) {
            return null;
        }
        StoryChangeEventIntegrator integrator = event.createIntegrator();
        integrator.addEvent(event);
        change = new AddDescriptionsChange(this.newDesc);
        integrator.addEvent(change.apply(source, model));
        return integrator.asEvent();
    }
}

