/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.notify;

import com.google.common.collect.ForwardingTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import edu.mit.story.core.notify.INotifyCollectionCallback;
import edu.mit.story.core.notify.INotifyMapCallback;
import edu.mit.story.core.notify.INotifyTableCallback;
import edu.mit.story.core.notify.NotifyingMap;
import edu.mit.story.core.notify.NotifyingSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyingTable<R, C, V>
extends ForwardingTable<R, C, V> {
    protected final Table<R, C, V> backingTable;
    protected final INotifyTableCallback<R, C, V> callback;
    protected Set<Table.Cell<R, C, V>> cellSet;
    protected Map<R, Map<C, V>> rowMap;
    protected Map<C, Map<R, V>> columnMap;

    public NotifyingTable(INotifyTableCallback<R, C, V> callback) {
        this((Table<R, C, V>)HashBasedTable.create(), callback);
    }

    public NotifyingTable(Table<R, C, V> backingTable, INotifyTableCallback<R, C, V> callback) {
        if (backingTable == null) {
            throw new NullPointerException();
        }
        if (callback == null) {
            throw new NullPointerException();
        }
        this.backingTable = backingTable;
        this.callback = callback;
    }

    protected void notifyAdd(R row, C col, V value) {
        this.callback.mappingAdded(row, col, value);
    }

    protected void notifyModify(R row, C col, V newValue, V oldValue) {
        this.callback.mappingModified(row, col, newValue, oldValue);
    }

    protected void notifyRemove(R row, C col, V value) {
        this.callback.mappingRemoved(row, col, value);
    }

    protected Table<R, C, V> delegate() {
        return this.backingTable;
    }

    public V put(R row, C col, V newValue) {
        boolean containsCell = this.backingTable.contains(row, col);
        Object oldValue = this.backingTable.put(row, col, newValue);
        if (containsCell) {
            if (oldValue != newValue) {
                this.notifyModify(row, col, newValue, oldValue);
            }
        } else {
            this.notifyAdd(row, col, newValue);
        }
        return (V)oldValue;
    }

    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        for (Table.Cell cell : table.cellSet()) {
            this.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
        }
    }

    public V remove(Object row, Object col) {
        boolean containsCell = this.backingTable.contains(row, col);
        Object value = this.backingTable.remove(row, col);
        if (containsCell) {
            this.notifyRemove(row, col, value);
        }
        return (V)value;
    }

    public void clear() {
        this.cellSet().clear();
    }

    public Set<Table.Cell<R, C, V>> cellSet() {
        if (this.cellSet == null) {
            this.cellSet = new NotifyingSet<Table.Cell<R, C, V>>(this.backingTable.cellSet(), new INotifyCollectionCallback<Table.Cell<R, C, V>>(){

                @Override
                public void elementAdded(Table.Cell<R, C, V> added) {
                    NotifyingTable.this.notifyAdd(added.getRowKey(), added.getColumnKey(), added.getValue());
                }

                @Override
                public void elementRemoved(Table.Cell<R, C, V> removed) {
                    NotifyingTable.this.notifyRemove(removed.getRowKey(), removed.getColumnKey(), removed.getValue());
                }
            });
        }
        return this.cellSet;
    }

    public Map<R, V> column(C columnKey) {
        return new NotifyingMap<R, V>(super.column(columnKey), this.makeColumnCallback(columnKey));
    }

    public Map<C, V> row(R rowKey) {
        return new NotifyingMap<C, V>(super.row(rowKey), this.makeRowCallback(rowKey));
    }

    protected INotifyMapCallback<R, V> makeColumnCallback(final C col) {
        return new INotifyMapCallback<R, V>(){

            @Override
            public void mappingAdded(R row, V value) {
                NotifyingTable.this.notifyAdd(row, col, value);
            }

            @Override
            public void mappingModified(R row, V newValue, V oldValue) {
                NotifyingTable.this.notifyModify(row, col, newValue, oldValue);
            }

            @Override
            public void mappingRemoved(R row, V value) {
                NotifyingTable.this.notifyRemove(row, col, value);
            }
        };
    }

    protected INotifyMapCallback<C, V> makeRowCallback(final R row) {
        return new INotifyMapCallback<C, V>(){

            @Override
            public void mappingAdded(C col, V value) {
                NotifyingTable.this.notifyAdd(row, col, value);
            }

            @Override
            public void mappingModified(C col, V newValue, V oldValue) {
                NotifyingTable.this.notifyModify(row, col, newValue, oldValue);
            }

            @Override
            public void mappingRemoved(C col, V value) {
                NotifyingTable.this.notifyRemove(row, col, value);
            }
        };
    }

    public Set<C> columnKeySet() {
        return this.columnMap().keySet();
    }

    public Set<R> rowKeySet() {
        return this.rowMap().keySet();
    }

    public Map<R, Map<C, V>> rowMap() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Map<C, Map<R, V>> columnMap() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotifyTableToCollectionCallback<R, C, V>
    implements INotifyCollectionCallback<Table.Cell<R, C, V>> {
        protected final INotifyTableCallback<R, C, V> callback;

        public NotifyTableToCollectionCallback(INotifyTableCallback<R, C, V> callback) {
            if (callback == null) {
                throw new NullPointerException();
            }
            this.callback = callback;
        }

        @Override
        public void elementAdded(Table.Cell<R, C, V> added) {
            this.callback.mappingAdded(added.getRowKey(), added.getColumnKey(), added.getValue());
        }

        @Override
        public void elementRemoved(Table.Cell<R, C, V> removed) {
            this.callback.mappingRemoved(removed.getRowKey(), removed.getColumnKey(), removed.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotifyingCellSet<R, C, V>
    extends NotifyingSet<Table.Cell<R, C, V>> {
        protected final INotifyTableCallback<R, C, V> callback;

        public NotifyingCellSet(Set<Table.Cell<R, C, V>> cellSet, INotifyTableCallback<R, C, V> callback) {
            super(cellSet, new NotifyTableToCollectionCallback<R, C, V>(callback));
            this.callback = callback;
        }

        @Override
        public boolean add(Table.Cell<R, C, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Table.Cell<R, C, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Table.Cell<R, C, V>> iterator() {
            return new NotifyingEntrySetIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class NotifyingEntrySetIterator
        implements Iterator<Table.Cell<R, C, V>> {
            protected Iterator<Table.Cell<R, C, V>> backingItr;
            protected Table.Cell<R, C, V> last;

            public NotifyingEntrySetIterator() {
                this.backingItr = NotifyingCellSet.this.backingSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.backingItr.hasNext();
            }

            @Override
            public Table.Cell<R, C, V> next() {
                this.last = this.backingItr.next();
                return this.last;
            }

            @Override
            public void remove() {
                this.backingItr.remove();
                NotifyingCellSet.this.callback.mappingRemoved(this.last.getRowKey(), this.last.getColumnKey(), this.last.getValue());
            }
        }
    }
}

