/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.position;

import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IntervalSet;
import edu.mit.story.core.position.RegionSet;
import edu.mit.story.core.util.Immutable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableIntervalSet
extends IntervalSet
implements Immutable {
    public ImmutableIntervalSet() {
    }

    public ImmutableIntervalSet(IHasPosition[] ps) {
        super(Arrays.asList(ps));
    }

    public ImmutableIntervalSet(Collection<? extends IHasPosition> c) {
        super(c);
    }

    public ImmutableIntervalSet(RegionSet parent, IHasPosition fromPos, IHasPosition toPos, int fromOffset, int toOffset, boolean open) {
        super(parent, fromPos, toPos, fromOffset, toOffset, open);
    }

    @Override
    protected RegionSet createSubset(RegionSet parent, IHasPosition fromElement, IHasPosition toElement, int fromOffset, int toOffset, boolean closed) {
        return new ImmutableIntervalSet(parent, fromElement, toElement, fromOffset, toOffset, closed);
    }

    @Override
    protected SortedMap<Integer, SortedSet<IHasPosition>> createOffsetMap(Collection<? extends IHasPosition> c) {
        IntervalSet hiddenSet = new IntervalSet(c);
        TreeMap hiddenMap = new TreeMap();
        for (Map.Entry entry : hiddenSet.offsetMap.entrySet()) {
            if (((SortedSet)entry.getValue()).isEmpty()) continue;
            hiddenMap.put((Integer)entry.getKey(), Collections.unmodifiableSortedSet((SortedSet)entry.getValue()));
        }
        return Collections.unmodifiableSortedMap(hiddenMap);
    }

    @Override
    protected SortedSet<IHasPosition> createOffsetSet(Collection<? extends IHasPosition> c) {
        TreeSet<? super IHasPosition> hidden = new TreeSet<IHasPosition>(this.comparator());
        hidden.addAll(c);
        return Collections.unmodifiableSortedSet(hidden);
    }
}

