/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.util;

import edu.mit.story.core.util.IEnableable;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnabledItemListIterator<T extends IEnableable>
implements ListIterator<T> {
    List<T> list;
    ListIterator<T> listItr;

    public EnabledItemListIterator(List<T> list) {
        this.list = list;
        this.listItr = list.listIterator();
    }

    public EnabledItemListIterator(List<T> list, int index) {
        this.list = list;
        this.listItr = list.listIterator(index);
    }

    @Override
    public void add(T o) {
        this.listItr.add(o);
    }

    @Override
    public boolean hasNext() {
        int i = this.listItr.nextIndex();
        while (i < this.list.size()) {
            if (((IEnableable)this.list.get(i)).isEnabled()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean hasPrevious() {
        int i = this.listItr.previousIndex();
        while (i >= 0) {
            if (((IEnableable)this.list.get(i)).isEnabled()) {
                return true;
            }
            --i;
        }
        return false;
    }

    @Override
    public T next() {
        IEnableable item;
        while (!(item = (IEnableable)this.listItr.next()).isEnabled()) {
        }
        return (T)item;
    }

    @Override
    public int nextIndex() {
        int i = this.listItr.nextIndex();
        while (i < this.list.size()) {
            if (((IEnableable)this.list.get(i)).isEnabled()) {
                return i;
            }
            ++i;
        }
        return this.list.size();
    }

    @Override
    public T previous() {
        IEnableable item;
        while (!(item = (IEnableable)this.listItr.previous()).isEnabled()) {
        }
        return (T)item;
    }

    @Override
    public int previousIndex() {
        int i = this.listItr.previousIndex();
        while (i >= 0) {
            if (((IEnableable)this.list.get(i)).isEnabled()) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public void remove() {
        this.listItr.remove();
    }

    @Override
    public void set(T o) {
        this.listItr.set(o);
    }
}

