/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.context.model;

import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.parsing.core.model.ISegmentSetModel;
import edu.mit.parsing.core.model.SegmentSetModel;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.context.ContextRelation;
import edu.mit.semantics.core.rep.context.ContextRelationRep;
import edu.mit.semantics.core.rep.context.IContextArg;
import edu.mit.semantics.core.rep.context.IContextRelation;
import edu.mit.semantics.core.rep.context.IContextRole;
import edu.mit.semantics.core.rep.context.model.ContextRelArgModel;
import edu.mit.semantics.core.rep.context.model.IContextRelArgModel;
import edu.mit.semantics.core.rep.context.model.IContextRelationModel;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.notify.INotifyCollectionCallback;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.notify.NotifyingList;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.validation.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextRelationModel
extends AbstractViewModel
implements IContextRelationModel {
    public static final Message needsTwoArgsMessage = new Message("Select at least two arguments", 3);
    public static final Message noGroupsForBinaryRelations = new Message("A binary relation should not have a head", 3);
    public static final Message mixedWordnetPropbankRoles = new Message("This relation uses mixed Wordnet and Propbank role markings", 2);
    public static final Message mixedPropbankFrames = new Message("This relation uses mixed Propbank frame role markings", 2);
    private final IStoryModel model;
    private IDesc loaded = null;
    private final ISegmentSetModel signal;
    private final MessageProviderManager manager = new MessageProviderManager(new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            ContextRelationModel.this.fireChanged();
        }
    });
    private final List<IContextRelArgModel> args = new NotifyingList((INotifyCollectionCallback)new INotifyCollectionCallback<IContextRelArgModel>(){

        public void elementAdded(IContextRelArgModel added) {
            ContextRelationModel.this.manager.add((INotifyingMessageProvider)added);
            ContextRelationModel.this.fireChanged();
        }

        public void elementRemoved(IContextRelArgModel removed) {
            ContextRelationModel.this.manager.remove((INotifyingMessageProvider)removed);
            ContextRelationModel.this.fireChanged();
        }
    });

    public ContextRelationModel(IStoryModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        this.model = model;
        this.signal = new SegmentSetModel(TokenRep.getInstance(), model);
        this.signal.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ContextRelationModel.this.fireChanged();
            }
        });
    }

    @Override
    public IStoryModel getStoryModel() {
        return this.model;
    }

    @Override
    public ISegmentSetModel getSignalModel() {
        return this.signal;
    }

    @Override
    public ISegmentSet getSignal() {
        if (this.signal.getSegments().isEmpty()) {
            return null;
        }
        return new SegmentSet((Collection)this.signal.getSegments());
    }

    @Override
    public List<IContextRelArgModel> getArguments() {
        return this.args;
    }

    public IHasPosition calculatePosition() {
        throw new UnsupportedOperationException();
    }

    public IHasPosition getDisplayPosition() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IDesc getLoaded() {
        return this.loaded;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load(IDesc desc) {
        void var4_8;
        ContextRelationRep.getInstance().checkType((IHasRep)desc);
        this.internalClear();
        this.loaded = desc;
        IContextRelation rel = (IContextRelation)desc.getData();
        for (IContextArg iContextArg : rel.getArguments()) {
            ContextRelArgModel argModel = new ContextRelArgModel(this.getStoryModel());
            argModel.load(iContextArg);
            this.getArguments().add(argModel);
        }
        ISegmentSet iSegmentSet = rel.getSignal();
        if (iSegmentSet == null) {
            Set set = Collections.emptySet();
        }
        this.signal.setSegments((Collection)var4_8);
    }

    protected void internalClear() {
        this.loaded = null;
        this.signal.clear();
        this.args.clear();
    }

    public boolean isCleared() {
        if (this.loaded != null) {
            return false;
        }
        if (!this.signal.isCleared()) {
            return false;
        }
        return this.args.isEmpty();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        throw new UnsupportedOperationException();
    }

    protected IMessageProvider calculateMessage() {
        if (this.args.size() < 2) {
            return needsTwoArgsMessage;
        }
        if (this.args.size() == 2) {
            for (IContextRelArgModel arg : this.args) {
                if (arg.getExclusionGroup() <= 0) continue;
                return noGroupsForBinaryRelations;
            }
        }
        HashSet<IContextRole.RoleType> types = new HashSet<IContextRole.RoleType>(this.args.size());
        HashSet<IRoleset> frames = new HashSet<IRoleset>(this.args.size());
        for (IContextRelArgModel arg : this.args) {
            IContextRole.RoleType type = arg.getRole().getType();
            types.add(type);
            if (type != IContextRole.RoleType.PROPBANK) continue;
            frames.add(arg.getRole().getPropbankRole().getRoleset());
        }
        if (types.contains((Object)IContextRole.RoleType.PROPBANK) && types.contains((Object)IContextRole.RoleType.WORDNET)) {
            return mixedWordnetPropbankRoles;
        }
        if (types.contains((Object)IContextRole.RoleType.PROPBANK) && frames.size() > 1) {
            return mixedPropbankFrames;
        }
        return this.manager.getFixedMessage();
    }

    @Override
    public IContextRelation create() {
        ArrayList<IContextArg> args = new ArrayList<IContextArg>(this.getArguments().size());
        for (IContextRelArgModel model : this.getArguments()) {
            args.add(model.create());
        }
        return new ContextRelation((Collection<? extends ISegment>)this.getSignal(), args);
    }
}

