/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event.rules;

import edu.mit.semantics.core.rep.event.Aspect;
import edu.mit.semantics.core.rep.event.EventClass;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.event.POS;
import edu.mit.semantics.core.rep.event.Tense;
import edu.mit.semantics.core.rep.event.problems.UnspecifiedFeatureProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoUnspecifiedFeaturesRule
extends AbstractBuildRule {
    public NoUnspecifiedFeaturesRule() {
        super(EventRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        HashSet<IDesc> ds = new HashSet<IDesc>();
        for (IDesc desc : model.getData().getDescriptions(EventRep.getInstance())) {
            IEvent event = (IEvent)desc.getData();
            if (event.getEventClass() != EventClass.UNSPECIFIED && event.getAspect() != Aspect.UNSPECIFIED && event.getPOS() != POS.UNSPECIFIED && event.getTense() != Tense.UNSPECIFIED) continue;
            ds.add(desc);
        }
        if (ds.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        if (this.isCompressing()) {
            result.add((Object)new UnspecifiedFeatureProblem(ds, this.getID()));
        } else {
            for (IDesc d : ds) {
                result.add((Object)new UnspecifiedFeatureProblem(d, this.getID()));
            }
        }
        return result;
    }
}

