/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.function.model;

import edu.mit.semantics.core.rep.function.Function;
import edu.mit.semantics.core.rep.function.FunctionTag;
import edu.mit.semantics.core.rep.function.IFunction;
import edu.mit.semantics.core.rep.function.IFunctionInstance;
import edu.mit.semantics.core.rep.function.IFunctionTag;
import edu.mit.semantics.core.rep.function.model.FunctionInstanceModel;
import edu.mit.semantics.core.rep.function.model.IFunctionInstanceModel;
import edu.mit.semantics.core.rep.function.model.IFunctionModel;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.notify.INotifyCollectionCallback;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.NotifyingHasPositionSet;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.validation.Message;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionModel
extends AbstractViewModel
implements IFunctionModel {
    private static final Message noInstanceMsg = new Message("Please create an instance", 3);
    private static final Message symbolEmptyMsg = new Message("Please specify a symbol for the function", 3);
    private static final Message underscoreMsg = new Message("Symbols and subtypes may not contain underscores", 3);
    private static final Message subtypeEmptyMsg = new Message("Most functions need a symbol subtype", 2);
    private final IStoryModel model;
    private final MessageProviderManager manager;
    private final INotifyCollectionCallback<IFunctionInstanceModel> callback = new INotifyCollectionCallback<IFunctionInstanceModel>(){

        public void elementAdded(IFunctionInstanceModel added) {
            FunctionModel.this.manager.add((INotifyingMessageProvider)added);
            FunctionModel.this.fireChanged();
        }

        public void elementRemoved(IFunctionInstanceModel removed) {
            FunctionModel.this.manager.remove((INotifyingMessageProvider)removed);
            FunctionModel.this.fireChanged();
        }
    };
    private final IHasPositionSet<IFunctionInstanceModel> instances = new NotifyingHasPositionSet(this.callback);
    private IDesc loaded = null;
    private String symbol = this.getDefaultSymbol();
    private boolean isInverted = this.getDefaultInverted();
    private String subtype = this.getDefaultSubtype();

    public FunctionModel(IStoryModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        this.model = model;
        this.manager = new MessageProviderManager(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FunctionModel.this.fireChanged();
            }
        });
    }

    @Override
    public IStoryModel getStoryModel() {
        return this.model;
    }

    @Override
    public void setSymbol(String newSymbol) {
        if (newSymbol == null) {
            newSymbol = this.getDefaultSymbol();
        }
        if (this.symbol.equals(newSymbol = newSymbol.trim())) {
            return;
        }
        this.symbol = newSymbol;
        this.fireChanged();
    }

    @Override
    public void setInverted(boolean value) {
        if (this.isInverted == value) {
            return;
        }
        this.isInverted = value;
        this.fireChanged();
    }

    @Override
    public void setSubtype(String newSubtype) {
        if (newSubtype == null) {
            newSubtype = this.getDefaultSubtype();
        }
        if (this.subtype.equals(newSubtype = newSubtype.trim())) {
            return;
        }
        this.subtype = newSubtype;
        this.fireChanged();
    }

    @Override
    public IFunctionTag getFunctionTag() {
        return new FunctionTag(this.symbol, this.isInverted, this.subtype);
    }

    public IHasPosition getDisplayPosition() {
        return this.calculatePosition();
    }

    public IHasPosition calculatePosition() {
        return PositionUtils.combineAll(this.instances);
    }

    @Override
    public IDesc getLoaded() {
        return this.loaded;
    }

    @Override
    public void load(IDesc desc) {
        IFunction function = (IFunction)desc.getData();
        this.clear();
        this.loaded = desc;
        IFunctionTag tag = function.getFunctionTag();
        this.setSymbol(tag.getSymbol());
        this.setSubtype(tag.getSubtype());
        this.setInverted(tag.isInverted());
        for (IFunctionInstance instance : function.getInstances()) {
            FunctionInstanceModel instanceModel = new FunctionInstanceModel(this.model);
            instanceModel.load(instance);
            this.instances.add((Object)instanceModel);
        }
    }

    protected void internalClear() {
        this.loaded = null;
        this.symbol = this.getDefaultSymbol();
        this.isInverted = this.getDefaultInverted();
        this.subtype = this.getDefaultSubtype();
        this.instances.clear();
    }

    public boolean isCleared() {
        if (this.loaded != null) {
            return false;
        }
        if (!this.symbol.equals(this.getDefaultSymbol())) {
            return false;
        }
        if (!this.subtype.equals(this.getDefaultSubtype())) {
            return false;
        }
        if (this.isInverted != this.getDefaultInverted()) {
            return false;
        }
        return this.instances.isEmpty();
    }

    protected IMessageProvider calculateMessage() {
        if (this.symbol.equals("")) {
            return symbolEmptyMsg;
        }
        if (this.symbol.indexOf(95) > -1 || this.subtype.indexOf(95) > -1) {
            return underscoreMsg;
        }
        if (this.instances.isEmpty()) {
            return noInstanceMsg;
        }
        if (this.manager.getMessageType() > 1) {
            return this.manager.getFixedMessage();
        }
        if (this.subtype.equals("")) {
            return subtypeEmptyMsg;
        }
        return this.manager.getFixedMessage();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        throw new UnsupportedOperationException();
    }

    protected String getDefaultSubtype() {
        return "";
    }

    protected boolean getDefaultInverted() {
        return false;
    }

    protected String getDefaultSymbol() {
        return "";
    }

    @Override
    public IHasPositionSet<IFunctionInstanceModel> getInstances() {
        return this.instances;
    }

    @Override
    public IFunction create() {
        ArrayList<IFunctionInstance> results = new ArrayList<IFunctionInstance>(this.instances.size());
        for (IFunctionInstanceModel instModel : this.instances) {
            results.add(instModel.create());
        }
        return new Function(this.getFunctionTag(), results);
    }
}

