/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.semrole;

import edu.mit.parsing.core.rep.parse.ParseRep;
import edu.mit.semantics.core.SemanticsPlugin;
import edu.mit.semantics.core.rep.semrole.ISemRole;
import edu.mit.semantics.core.rep.semrole.ISemRoleLabeler;
import edu.mit.semantics.core.rep.semrole.IndexedSemRole;
import edu.mit.semantics.core.rep.semrole.SemRoleRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.ManagerBackedListValidator;
import edu.mit.story.core.validation.PreferenceStoreBackedPropertyDescriptor;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemRoleDescFactory
extends AbstractDescFactory2<IndexedSemRole> {
    private ISemRoleLabeler labeler;

    public SemRoleDescFactory() {
        super(SemRoleRep.getInstance(), ParseRep.getInstance());
    }

    protected boolean doInit(IStoryModel data) {
        String labelerID = (String)this.getConfiguration().get((Object)"semRoleLabeler");
        if (labelerID == null) {
            return false;
        }
        this.labeler = (ISemRoleLabeler)SemanticsPlugin.getDefault().getSemRoleLabelerManager().create(labelerID);
        if (this.labeler == null) {
            return false;
        }
        IConfiguration config = this.getConfiguration().getConfiguration("semRoleLabeler");
        if (config != null) {
            this.labeler.configure(config);
        }
        this.labeler.init();
        return true;
    }

    public void dispose(IStoryModel model) {
        if (this.labeler != null) {
            this.labeler.dispose();
        }
        this.labeler = null;
    }

    protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
        Change change = event.getChange(ParseRep.getInstance());
        if (change == null) {
            return null;
        }
        IHasPositionSet regions = change.getChanges((IFlag)Flag.DESCS);
        if (regions == null || regions.isEmpty()) {
            return null;
        }
        DistinctRegionSet result = new DistinctRegionSet();
        IDescSet descs = event.provider.getData().getDescriptions(ParseRep.getInstance());
        for (IHasPosition region : regions) {
            result.addAll((Collection)descs.openSet(region));
        }
        return result;
    }

    protected IHasPositionSet<IndexedSemRole> calculateData(IHasPosition region, IStoryModel model) {
        HasPositionSet result = new HasPositionSet();
        IDescSet descs = model.getData().getDescriptions(ParseRep.getInstance()).closedSet(region);
        for (IDesc desc : descs) {
            for (ISemRole semrole : this.labeler.label(desc, model)) {
                result.add((Object)new IndexedSemRole(semrole.calculatePosition(), semrole));
            }
        }
        return result;
    }

    protected IConfigDescriptor createConfigurationDescriptor() {
        return new FactoryConfigDescriptor(this.getID(), this.getName(), this.getDescription());
    }

    public static class FactoryConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public FactoryConfigDescriptor(String id, String name, String desc) {
            this();
            this.setID(id);
            this.setName(name);
            this.setDescription(desc);
        }

        public FactoryConfigDescriptor() {
            PreferenceStoreBackedPropertyDescriptor d = new PreferenceStoreBackedPropertyDescriptor("semRoleLabeler", "Semantic Role Labeler", "Type of Semantic Role Labeler", (IValidator)new ManagerBackedListValidator(SemanticsPlugin.getDefault().getSemRoleLabelerManager()), true, "DefaultSemRoleLabelerID", SemanticsPlugin.getDefault().getPreferenceStore());
            this.put(d.getID(), d);
        }
    }
}

