/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timex3.model;

import edu.mit.parsing.core.model.ISegmentSetModel;
import edu.mit.parsing.core.model.SegmentSetModel;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.timex3.ITimex3;
import edu.mit.semantics.core.rep.timex3.Timex3;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.semantics.core.rep.timex3.model.ITimex3Model;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IHasSegments;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.validation.Message;
import java.util.Collection;
import java.util.Collections;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;

public class Timex3Model
extends SegmentSetModel
implements ITimex3Model,
ChangeListener {
    public static final Message noTypeMessage = new Message("Select a type", 3);
    public static final Message noModMessage = new Message("Select a modifier", 3);
    public static final Message noFuncMessage = new Message("Select a function", 3);
    public static final Message missingExpressionTokenMessage = new Message("The expression is missing a token included in the quantifier or freqency", 3);
    public static final Message typeMustBeSetMessage = new Message("The type must be a SET if the frequency or quantification fields are not empty", 3);
    private ITimex3.Type type = this.getDefaultType();
    private ITimex3.Mod mod = this.getDefaultMod();
    private ITimex3.Function func = this.getDefaultFunc();
    private boolean isTempFunc = false;
    private IDesc loaded = null;
    private String value = null;
    private final ISegmentSetModel quant;
    private final ISegmentSetModel freq;

    public Timex3Model(IStoryModel model) {
        super(TokenRep.getInstance(), model);
        this.quant = new SegmentSetModel(TokenRep.getInstance(), model);
        this.freq = new SegmentSetModel(TokenRep.getInstance(), model);
        this.quant.addChangeListener((ChangeListener)this);
        this.freq.addChangeListener((ChangeListener)this);
    }

    public void stateChanged(ChangeEvent e) {
        if (!(this.type == ITimex3.Type.SET || this.quant.getSegments().isEmpty() && this.freq.getSegments().isEmpty())) {
            this.setType(ITimex3.Type.SET);
        } else {
            this.fireChanged();
        }
    }

    public ISegmentSet getExpression() {
        IHasPositionSet segs = this.getSegments();
        if (segs == null || segs.isEmpty()) {
            return null;
        }
        return new SegmentSet((Collection)segs);
    }

    public ISegmentSet getFrequency() {
        IHasPositionSet segs = this.freq.getSegments();
        if (segs == null || segs.isEmpty()) {
            return null;
        }
        return new SegmentSet((Collection)segs);
    }

    public ISegmentSet getQuantifier() {
        IHasPositionSet segs = this.quant.getSegments();
        if (segs == null || segs.isEmpty()) {
            return null;
        }
        return new SegmentSet((Collection)segs);
    }

    public ITimex3.Type getType() {
        return this.type;
    }

    public ITimex3.Function getFunction() {
        return this.func;
    }

    public ITimex3.Mod getModifier() {
        return this.mod;
    }

    public String getValue() {
        return this.value;
    }

    public ISegmentSetModel getFrequencyModel() {
        return this.freq;
    }

    public ISegmentSetModel getQuantificationModel() {
        return this.quant;
    }

    public void setType(ITimex3.Type type) {
        if (this.type == type || type == null) {
            return;
        }
        this.type = type;
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    public void setFunctionInDoc(ITimex3.Function func) {
        this.func = func;
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    public void setModification(ITimex3.Mod mod) {
        this.mod = mod;
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    public boolean isTemporalFunction() {
        return this.isTempFunc;
    }

    public void setValue(String newValue) {
        if (newValue == null) {
            if (this.value == null) {
                return;
            }
            this.value = newValue;
        } else {
            if ((newValue = newValue.trim()).equals(this.value)) {
                return;
            }
            this.value = newValue.length() == 0 ? null : newValue;
        }
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    public void setTemporalFunction(boolean val) {
        this.isTempFunc = val;
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    public IHasPosition calculatePosition() {
        throw new UnsupportedOperationException();
    }

    public IHasPosition getDisplayPosition() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        throw new UnsupportedOperationException();
    }

    public IDesc getLoaded() {
        return this.loaded;
    }

    public void load(IDesc desc) {
        if (!Timex3Rep.getInstance().isType((IHasRep)desc)) {
            return;
        }
        this.internalClear();
        this.loaded = desc;
        ITimex3 timex = (ITimex3)desc.getData();
        this.type = timex.getType();
        this.func = timex.getFunction();
        this.mod = timex.getModifier();
        this.value = timex.getValue();
        this.isTempFunc = timex.isTemporalFunction();
        Object segments = timex.getExpression();
        if (segments == null) {
            segments = Collections.emptySet();
        }
        this.setSegments((Collection)segments);
        segments = timex.getQuantifier();
        if (segments == null) {
            segments = Collections.emptySet();
        }
        this.quant.setSegments((Collection)segments);
        segments = timex.getFrequency();
        if (segments == null) {
            segments = Collections.emptySet();
        }
        this.freq.setSegments((Collection)segments);
    }

    protected void internalClear() {
        this.loaded = null;
        this.type = this.getDefaultType();
        this.mod = this.getDefaultMod();
        this.func = this.getDefaultFunc();
        this.quant.clear();
        this.freq.clear();
        this.value = null;
        this.isTempFunc = false;
        super.internalClear();
    }

    public boolean isCleared() {
        if (this.type != this.getDefaultType()) {
            return false;
        }
        if (this.mod != this.getDefaultMod()) {
            return false;
        }
        if (this.func != this.getDefaultFunc()) {
            return false;
        }
        if (!this.quant.isCleared()) {
            return false;
        }
        if (!this.freq.isCleared()) {
            return false;
        }
        if (this.isTempFunc) {
            return false;
        }
        if (this.value != null) {
            return false;
        }
        return super.isCleared();
    }

    protected ITimex3.Type getDefaultType() {
        return ITimex3.Type.UNSPECIFIED;
    }

    protected ITimex3.Mod getDefaultMod() {
        return ITimex3.Mod.NONE;
    }

    protected ITimex3.Function getDefaultFunc() {
        return ITimex3.Function.NONE;
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        throw new UnsupportedOperationException();
    }

    protected IMessageProvider calculateMessage() {
        if (this.type == ITimex3.Type.UNSPECIFIED) {
            return noTypeMessage;
        }
        if (this.mod == ITimex3.Mod.UNSPECIFIED) {
            return noModMessage;
        }
        if (this.func == ITimex3.Function.UNSPECIFIED) {
            return noFuncMessage;
        }
        if ((this.getQuantifier() != null || this.getQuantifier() != null) && this.type != ITimex3.Type.SET) {
            return typeMustBeSetMessage;
        }
        IDescSet allDescs = Segment.extractSegmentDescriptions((IHasSegments)this);
        if (!this.quant.getSegments().isEmpty()) {
            for (IDesc segDesc : Segment.extractSegmentDescriptions((IHasSegments)this.quant)) {
                if (allDescs.contains((Object)segDesc)) continue;
                return missingExpressionTokenMessage;
            }
        }
        if (!this.freq.getSegments().isEmpty()) {
            for (IDesc segDesc : Segment.extractSegmentDescriptions((IHasSegments)this.freq)) {
                if (allDescs.contains((Object)segDesc)) continue;
                return missingExpressionTokenMessage;
            }
        }
        return super.calculateMessage();
    }

    public ITimex3 toTimex3() {
        return new Timex3((Collection<? extends ISegment>)this.getSegments(), this.type, this.mod, this.func, (Collection<? extends ISegment>)this.quant.getSegments(), (Collection<? extends ISegment>)this.freq.getSegments());
    }
}

