/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.helpers;

import edu.mit.semantics.core.rep.function.FunctionRep;
import edu.mit.semantics.ui.content.FunctionContentProvider;
import edu.mit.semantics.ui.label.FunctionLabelProvider;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.actions.editor.StoryEditorRedoAction;
import edu.mit.story.ui.actions.editor.StoryEditorUndoAction;
import edu.mit.story.ui.actions.generic.CollapseAllAction;
import edu.mit.story.ui.actions.generic.ExpandAllAction;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.IDetailsPage;
import edu.mit.story.ui.items.CommandHooks;
import edu.mit.story.ui.viewers.StoryElementComparer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.services.IServiceLocator;

public class FunctionDetailsPage
extends HelperPage
implements IDetailsPage,
IAdaptable {
    public static final String ID = FunctionDetailsPage.class.getName();
    private TreeViewer treeViewer;
    private IAction undoAction;
    private IAction redoAction;
    private IAction expandAction;
    private IAction collapseAction;
    private IModelListener refreshListener = new IModelListener(){

        public void modelChanged(StoryChangeEvent e) {
            if (FunctionDetailsPage.this.treeViewer == null) {
                return;
            }
            if (FunctionDetailsPage.this.treeViewer.getTree().isDisposed()) {
                return;
            }
            if (e.affects(FunctionRep.getInstance())) {
                FunctionDetailsPage.this.treeViewer.refresh();
            }
        }
    };

    public void createControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 772);
        this.treeViewer.setAutoExpandLevel(3);
        this.treeViewer.setContentProvider((IContentProvider)new FunctionContentProvider(this.getStoryEditor()));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new FunctionLabelProvider(this.getStoryEditor()));
        this.treeViewer.setComparer((IElementComparer)StoryElementComparer.getInstance());
        this.treeViewer.setInput((Object)this.getStoryEditor());
        this.setControl((Control)this.treeViewer.getTree());
        CommandContributionItem deleteItem = CommandHooks.createDelete((IServiceLocator)this.getSite().getWorkbenchWindow());
        CommandContributionItem editItem = CommandHooks.createEdit((IServiceLocator)this.getSite().getWorkbenchWindow());
        this.undoAction = new StoryEditorUndoAction(this.getStoryEditor());
        this.redoAction = new StoryEditorRedoAction(this.getStoryEditor());
        this.expandAction = new ExpandAllAction((AbstractTreeViewer)this.treeViewer);
        this.collapseAction = new CollapseAllAction((AbstractTreeViewer)this.treeViewer, 2);
        MenuManager menu = new MenuManager();
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener(new IMenuListener((IContributionItem)editItem, (IContributionItem)deleteItem){
            private final /* synthetic */ IContributionItem val$editItem;
            private final /* synthetic */ IContributionItem val$deleteItem;
            {
                this.val$editItem = iContributionItem;
                this.val$deleteItem = iContributionItem2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                ActionUtils.createPopupGroups((IMenuManager)manager);
                manager.appendToGroup("group.edit", this.val$editItem);
                manager.appendToGroup("group.edit", this.val$deleteItem);
            }
        });
        this.getControl().setMenu(menu.createContextMenu(this.getControl()));
        this.getSite().registerContextMenu(String.valueOf(ID) + ".popupMenu", menu, (ISelectionProvider)this.treeViewer);
    }

    public void setActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redoAction);
        actionBars.getToolBarManager().insertBefore("linking", this.collapseAction);
        actionBars.getToolBarManager().insertBefore(this.collapseAction.getId(), this.expandAction);
    }

    public void setStoryEditor(IStoryEditor newEditor) {
        super.setStoryEditor(newEditor);
        this.getStoryEditor().getStoryModel().addModelListener(this.refreshListener);
    }

    public void dispose() {
        this.getStoryEditor().getStoryModel().removeModelListener(this.refreshListener);
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionProvider.class) {
            return this.treeViewer;
        }
        if (adapter == IPostSelectionProvider.class) {
            return this.treeViewer;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

