/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.discourse.core.rep.coref.ICoref;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.mentalstate.IMentalState;
import edu.mit.semantics.core.rep.mentalstate.MentalStateRep;
import edu.mit.semantics.ui.SemanticsUIPlugin;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class MentalStateLabelProvider
extends StoryModelLabelProvider {
    protected Image eventImg;
    protected Image stateImg;

    public MentalStateLabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public StyledString getStyledText(Object element) {
        IDesc desc = null;
        if (element instanceof IDesc) {
            desc = (IDesc)element;
            element = desc.getData();
        }
        if (element instanceof IEvent) {
            IEvent e = (IEvent)element;
            StyledString result = new StyledString();
            result.append(e.getEventTokens().getDisplayText());
            result.append(" - ", StyledString.DECORATIONS_STYLER);
            result.append(e.getEventClass().getName(), StyledString.DECORATIONS_STYLER);
            return MentalStateLabelProvider.appendID((StyledString)result, (long)desc.getID());
        }
        if (element instanceof IMentalState) {
            IMentalState s = (IMentalState)element;
            ICoref character = (ICoref)s.getCharacter().getData();
            StyledString result = new StyledString();
            result.append(character.getName());
            result.append(" : ");
            result.append(s.getValence().getName(), StyledString.COUNTER_STYLER);
            if (desc == null) {
                return result;
            }
            result = MentalStateLabelProvider.appendID((StyledString)result, (long)desc.getID());
            return MentalStateLabelProvider.appendMergeTags((StyledString)result, (IDesc)desc);
        }
        return super.getStyledText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc && EventRep.getInstance().isType((IHasRep)((IDesc)element))) {
            return this.getEventImage();
        }
        if (element instanceof IDesc && MentalStateRep.getInstance().isType((IHasRep)((IDesc)element))) {
            return this.getStateImage();
        }
        return super.getImage(element);
    }

    public Image getEventImage() {
        if (this.eventImg == null) {
            this.eventImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/event.gif");
        }
        return this.eventImg;
    }

    public Image getStateImage() {
        if (this.stateImg == null) {
            this.stateImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/part.gif");
        }
        return this.stateImg;
    }
}

