/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.disambiguation;

import edu.mit.parsing.core.model.ISegmentSetModel;
import edu.mit.parsing.core.model.SegmentSetModel;
import edu.mit.parsing.core.rep.colloc.Colloc;
import edu.mit.parsing.core.rep.colloc.IColloc;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.pos.PennTag;
import edu.mit.parsing.core.rep.pos.PosData;
import edu.mit.parsing.core.rep.sentence.ISentence;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.IStemData;
import edu.mit.parsing.core.rep.stem.StemData;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.parsing.core.util.BaseWordInfo;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.datamodel.IViewModel;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IHasSegments;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.validation.Message;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import edu.mit.wordnet.core.rep.sense.disambiguation.IDisambiguationModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisambiguationModel
extends AbstractViewModel
implements IDisambiguationModel,
IViewModel,
ChangeListener {
    private final IDesc wordDesc;
    private final IStoryModel storyModel;
    private final ISegmentSetModel tokens;
    private final List<Object> choices = new LinkedList<Object>();
    private final Set<IDisambiguationModel> subsumed = new HashSet<IDisambiguationModel>();
    private final List<ITiming> timings = new LinkedList<ITiming>();
    private final List<ITiming> timingsExt = Collections.unmodifiableList(this.timings);
    private boolean isSubsumed = false;
    private boolean isEnabled = true;
    private IDisambiguationModel.AssignmentType type = IDisambiguationModel.AssignmentType.NORMAL;
    private Object choice = null;
    private IStemData stem = null;
    private IPosData tag = null;
    private List<Object> origChoices = null;

    public DisambiguationModel(IDesc desc, IStoryModel model) {
        this.storyModel = model;
        if (SenseRep.getInstance().isType((IHasRep)desc)) {
            ISense s = (ISense)desc.getData();
            this.wordDesc = s.getWord();
            this.choice = desc;
        } else {
            this.wordDesc = desc;
        }
        if (!IBaseToken.class.isAssignableFrom(this.wordDesc.getRep().getDataFormat())) {
            throw new IllegalArgumentException();
        }
        if (this.storyModel == null) {
            throw new NullPointerException();
        }
        this.tokens = new DisambiguationSegmentSetModel(this.wordDesc, this.storyModel);
        this.tokens.addChangeListener((ChangeListener)this);
    }

    @Override
    public IDesc getWordDesc() {
        return this.wordDesc;
    }

    @Override
    public IStoryModel getStoryModel() {
        return this.storyModel;
    }

    @Override
    public ISegmentSetModel getWordModel() {
        return this.tokens;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChanged();
    }

    @Override
    public IDescSet getSenses() {
        IDescSet matchSet = this.storyModel.getData().getDescriptions(SenseRep.getInstance()).matchSet((IHasPosition)this.wordDesc);
        DescSet result = new DescSet(SenseRep.getInstance());
        for (IDesc d : matchSet) {
            ISense s = (ISense)d.getData();
            if (s.getWord().getID() != this.wordDesc.getID()) continue;
            result.add((Object)d);
        }
        return result;
    }

    @Override
    public IDescSet getStems() {
        IDescSet matchSet = this.storyModel.getData().getDescriptions(StemRep.getInstance()).matchSet((IHasPosition)this.wordDesc);
        DescSet result = new DescSet(StemRep.getInstance());
        for (IDesc d : matchSet) {
            IStem s = (IStem)d.getData();
            if (s.getWord().getID() != this.wordDesc.getID()) continue;
            result.add((Object)d);
        }
        return result;
    }

    @Override
    public IDescSet getTags() {
        IDescSet matchSet = this.storyModel.getData().getDescriptions(POSRep.getInstance()).matchSet((IHasPosition)this.wordDesc);
        DescSet result = new DescSet(POSRep.getInstance());
        for (IDesc d : matchSet) {
            IPosTag p = (IPosTag)d.getData();
            if (p.getWord().getID() != this.wordDesc.getID()) continue;
            result.add((Object)d);
        }
        return result;
    }

    @Override
    public IDisambiguationModel.AssignmentType getAssignmentType() {
        return this.type;
    }

    @Override
    public boolean isSubsumed() {
        return this.isSubsumed;
    }

    @Override
    public boolean isDisambiguated() {
        if (this.type == IDisambiguationModel.AssignmentType.NORMAL) {
            return this.choice != null;
        }
        return true;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public IBaseWordInfo getModelInfo() {
        IBaseToken tokenInfo = (IBaseToken)this.wordDesc.getData();
        PosData tagInfo = null;
        IDescSet posDescs = this.getStoryModel().getData().getDescriptions(POSRep.getInstance()).matchSet((IHasPosition)this.wordDesc);
        for (IDesc posDesc : posDescs) {
            IPosTag tag = (IPosTag)posDesc.getData();
            if (tag.getWord() != this.wordDesc) continue;
            if (tagInfo != null) {
                tagInfo = null;
                break;
            }
            tagInfo = tag;
        }
        if (tagInfo == null) {
            tagInfo = new PosData((ITag)PennTag.UNKNOWN, false);
        }
        StemData stemInfo = null;
        IDescSet stemDescs = this.getStoryModel().getData().getDescriptions(StemRep.getInstance()).matchSet((IHasPosition)this.wordDesc);
        for (IDesc stemDesc : stemDescs) {
            IStem stem = (IStem)stemDesc.getData();
            if (stem.getWord() != this.wordDesc) continue;
            if (stemInfo != null) {
                stemInfo = null;
                break;
            }
            stemInfo = stem;
        }
        if (stemInfo == null) {
            stemInfo = new StemData(tokenInfo.getSurface());
        }
        return new BaseWordInfo(tokenInfo, (IPosData)tagInfo, (IStemData)stemInfo, null);
    }

    @Override
    public IBaseWordInfo getCurrentInfo() {
        IBaseWordInfo origInfo = this.getModelInfo();
        Object tokenInfo = null;
        IDescSet tokenDescs = Segment.extractSegmentDescriptions((IHasSegments)this.tokens);
        tokenInfo = tokenDescs.size() == 1 ? (IBaseToken)((IDesc)tokenDescs.first()).getData() : new Colloc((Collection)tokenDescs);
        IPosData tagInfo = this.tag != null ? this.tag : origInfo.getPosTag();
        IStemData stemInfo = this.stem != null ? this.stem : origInfo.getStem();
        IDescSet sentDescs = this.getStoryModel().getData().getDescriptions(SentenceRep.getInstance());
        sentDescs = sentDescs.closedSet((IHasPosition)this.wordDesc);
        ISentence sent = null;
        if (sentDescs.size() == 1) {
            sent = (ISentence)((IDesc)sentDescs.first()).getData();
        }
        return new BaseWordInfo((IBaseToken)tokenInfo, tagInfo, stemInfo, sent);
    }

    @Override
    public Object getChoice() {
        return this.choice;
    }

    @Override
    public ISenseAssignment getChosenSense() {
        if (this.choice instanceof ISenseAssignment) {
            return (ISenseAssignment)this.choice;
        }
        if (this.choice instanceof IDesc) {
            IDesc d = (IDesc)this.choice;
            return (ISenseAssignment)d.getData();
        }
        return null;
    }

    @Override
    public List<Object> getChoices() {
        return new ArrayList<Object>(this.choices);
    }

    @Override
    public List<ISentence> getContext() {
        IDescSet sentDescs = this.getStoryModel().getData().getDescriptions(SentenceRep.getInstance());
        IDesc left = null;
        IDesc middle = null;
        IDesc right = null;
        IDescSet middleDescs = sentDescs.closedSet((IHasPosition)this.wordDesc);
        IDesc iDesc = middle = middleDescs.isEmpty() ? null : (IDesc)middleDescs.first();
        if (middle != null) {
            left = (IDesc)PositionUtils.getPrevious((IHasPosition)middle, (IHasPositionSet)sentDescs);
            right = (IDesc)PositionUtils.getNext((IHasPosition)middle, (IHasPositionSet)sentDescs);
        }
        ArrayList<ISentence> context = new ArrayList<ISentence>(3);
        if (left != null && left != middle) {
            context.add((ISentence)left.getData());
        }
        if (middle != null) {
            context.add((ISentence)middle.getData());
        }
        if (right != null && right != middle) {
            context.add((ISentence)right.getData());
        }
        return context;
    }

    @Override
    public Set<IDisambiguationModel> getSubsumed() {
        return this.subsumed;
    }

    @Override
    public List<ITiming> getTimingList() {
        return this.timingsExt;
    }

    @Override
    public void setAssignmentType(IDisambiguationModel.AssignmentType type) {
        if (this.type == type) {
            return;
        }
        this.type = type;
        this.fireChanged();
    }

    @Override
    public void setSubsumed(boolean value) {
        if (this.isSubsumed == value) {
            return;
        }
        this.isSubsumed = value;
        this.fireChanged();
    }

    public boolean setEnabled(boolean value) {
        if (this.isEnabled == value) {
            return false;
        }
        this.isEnabled = value;
        return true;
    }

    @Override
    public void setChoice(Object choice) {
        if (this.choice == choice) {
            return;
        }
        this.choice = choice;
        this.fireChanged();
    }

    @Override
    public void setChoices(List<? extends Object> newChoices) {
        if (this.origChoices == null) {
            this.origChoices = newChoices == null ? Collections.emptyList() : new ArrayList<Object>(newChoices);
        }
        if (newChoices == null) {
            this.setChoices(this.origChoices);
            return;
        }
        if (this.choices.equals(newChoices)) {
            return;
        }
        this.choices.clear();
        this.choices.addAll(newChoices);
        this.fireChanged();
    }

    @Override
    public void setTag(IPosData newTag) {
        if (this.tag == newTag) {
            return;
        }
        if (newTag == null) {
            this.tag = null;
            this.fireChanged();
            return;
        }
        IBaseWordInfo info = this.getCurrentInfo();
        IPosData d = info.getPosTag();
        if (d.getTag().equals(newTag.getTag()) && d.isAuxiliary() == newTag.isAuxiliary()) {
            return;
        }
        this.tag = newTag;
        this.fireChanged();
    }

    @Override
    public void setStem(IStemData newStem) {
        if (newStem == this.stem) {
            return;
        }
        if (newStem == null) {
            this.stem = null;
            this.fireChanged();
            return;
        }
        IBaseWordInfo info = this.getCurrentInfo();
        if (info.getBaseForm().equals(newStem.getStem())) {
            return;
        }
        this.stem = newStem;
        this.fireChanged();
    }

    @Override
    public boolean isStemSet() {
        return this.stem != null;
    }

    @Override
    public boolean isTagSet() {
        return this.tag != null;
    }

    @Override
    public boolean isWordChanged() {
        return !Colloc.getWordTokens((IDesc)this.wordDesc).equals((Object)Segment.extractSegmentDescriptions((IHasSegments)this.tokens));
    }

    public boolean isCleared() {
        if (this.type != IDisambiguationModel.AssignmentType.NORMAL) {
            return false;
        }
        if (this.isSubsumed) {
            return false;
        }
        if (this.choice != null) {
            return false;
        }
        if (this.tag != null) {
            return false;
        }
        if (this.stem != null) {
            return false;
        }
        if (!this.origChoices.equals(this.choices)) {
            return false;
        }
        return !this.isWordChanged();
    }

    public void clear() {
        this.internalClear();
        this.fireChanged();
    }

    protected void internalClear() {
        this.type = IDisambiguationModel.AssignmentType.NORMAL;
        this.isSubsumed = false;
        this.choice = null;
        this.tag = null;
        this.stem = null;
        this.choices.clear();
        this.choices.addAll(this.origChoices);
        this.tokens.clear();
        this.subsumed.clear();
        this.timings.clear();
    }

    public int getLength() {
        return this.wordDesc.getLength();
    }

    public int getOffset() {
        return this.wordDesc.getOffset();
    }

    public int getRightOffset() {
        return this.wordDesc.getRightOffset();
    }

    protected IMessageProvider calculateMessage() {
        return Message.NO_MESSAGE;
    }

    public void dispose() {
        this.getWordModel().dispose();
    }

    public Date getStart() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DisambiguationSegmentSetModel
    extends SegmentSetModel {
        private final IDesc origToken;
        private final IDescSet origTokens;
        private final Collection<ISegment> origSegs;

        public DisambiguationSegmentSetModel(IDesc token, IStoryModel model) {
            super(TokenRep.getInstance(), model);
            this.origToken = token;
            if (TokenRep.getInstance().isType((IHasRep)token)) {
                this.origSegs = Collections.singleton(new Segment((IHasPosition)token, token.getRep(), model.getData()));
                this.origTokens = new DescSet(token);
            } else {
                IColloc c = (IColloc)token.getData();
                this.origSegs = Colloc.toSegments((IDescSet)c.getTokens(), (IStoryData)model.getData());
                this.origTokens = c.getTokens();
            }
            this.internalClear();
        }

        protected void internalClear() {
            super.internalClear();
            this.segments.addAll(this.origSegs);
        }

        public void setSegments(Collection<? extends ISegment> segs) {
            DescSet allTokens = new DescSet(TokenRep.getInstance());
            for (ISegment iSegment : segs) {
                allTokens.addAll((Collection)iSegment.getDescs());
            }
            IStoryData iStoryData = this.getStoryModel().getData();
            IDesc sentDesc = (IDesc)iStoryData.getDescriptions(SentenceRep.getInstance()).openSet((IHasPosition)this.origToken).first();
            ISentence sent = (ISentence)sentDesc.getData();
            allTokens.retainAll((Collection)sent.getTokens());
            boolean found = false;
            for (IDesc d : this.origTokens) {
                if (!allTokens.contains((Object)d)) continue;
                found = true;
                break;
            }
            if (!found) {
                allTokens.add((Object)((IDesc)this.origTokens.first()));
            }
            IHasPositionSet newSegs = Colloc.toSegments((IDescSet)allTokens, (IStoryData)iStoryData);
            super.setSegments((Collection)newSegs);
        }
    }
}

