/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.rules;

import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import edu.mit.wordnet.core.rep.sense.problems.TaggedAuxiliaryProblem;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoTaggedAuxiliariesRule
extends AbstractBuildRule {
    public static final String ID = NoTaggedAuxiliariesRule.class.getCanonicalName();

    public NoTaggedAuxiliariesRule() {
        super(SenseRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        IDescSet senseDescs = model.getData().getDescriptions(SenseRep.getInstance());
        HashSet<IDesc> tagged = new HashSet<IDesc>();
        for (IDesc senseDesc : senseDescs) {
            ISense sense = (ISense)senseDesc.getData();
            if (!sense.isAuxiliary()) continue;
            tagged.add(senseDesc);
        }
        if (tagged.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        if (this.isCompressing()) {
            if (!tagged.isEmpty()) {
                result.add((Object)new TaggedAuxiliaryProblem(tagged, this.getID()));
            }
        } else {
            for (IDesc d : tagged) {
                result.add((Object)new TaggedAuxiliaryProblem(d, this.getID()));
            }
        }
        return result;
    }
}

