/* Filename: IScoreCalculator.java
 * Author: Andrew B. Shapiro
 * Format: Java 2 v1.5.0
 * Date created: Jul 7, 2008
 */
package edu.mit.discourse.core.compare;

import edu.mit.story.core.model.StoryModel;

/**
 * 
 * 
 * @author Andrew B. Shapiro
 * @since 1.5.0 (Jul 7, 2008)
 */
public interface IScoreCalculator {
	
	/**
	 * Compares the two {@link StoryModel} objects and returns a qualified,
	 * hierarchical data-structure, a {@link ScoredElement}. The assembly of
	 * the <code>ScoredElement</code> is completely dependent upon the
	 * implementor and is the key feature of this interface.
	 * 
	 * @param leftStory
	 *            the "lefthand" <code>StoryModel</code> for comparison
	 * @param rightStory
	 *            the "righthand" <code>StoryModel</code> for comparison
	 * @return A <code>ScoredElement</code> object that represents the scoring
	 *         data assembled according to implementation.
	 */
	public IScoredElement scoreStories(StoryModel leftStory, StoryModel rightStory);

}
