/* Filename: AddEntityChange.java
 * Author: Mark A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Oct 23, 2007
 */
package edu.mit.discourse.core.rep.referent.change;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import edu.mit.discourse.core.DiscourseMessages;
import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.Referent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.IOrigin;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.ReplaceDescriptionChange;
import edu.mit.story.core.model.change.StoryChangeEvent;


/** One line description goes here...
 * More detail goes here...
 *
 * @author Mark A. Finlayson
 * @version 1.00, (Oct 23, 2007)
 * @since 1.5.0
 */
public class RenameReferentChange extends AbstractModelChange {
	
	protected String name;
	protected long id;
	protected ITiming timing;

	public RenameReferentChange(String name, IDesc desc, ITiming timing) {
		super(DiscourseMessages.CHANGE_RenameEntity_name);
		
		if(!desc.getRep().equals(ReferentRep.getInstance())) throw new IllegalArgumentException();
		if(name.trim().length() == 0) throw new IllegalArgumentException();
		
		this.name = name;
		this.id = desc.getID();
		this.timing = timing;
	}

	/* (non-Javadoc) @see edu.mit.story.core.provider.changes.AbstractSynchronizedProviderChange#synchronizedDoApply(java.lang.Object, edu.mit.story.core.provider.IDescriptionProvider) */
	@Override
	protected StoryChangeEvent doApply(Object source, IMutableStoryModel provider) {
		
		// get entity description
		IDesc oldDesc = provider.getData().getDescriptions(ReferentRep.getInstance()).getDescription(id);
		if(oldDesc == null) return null;
		
		// get the entity, check and see if it already has this segment
		IReferent oldData = (IReferent)oldDesc.getData();
		
		// construct the new reference map
		// if we can't find the reference to delete, don't do anything
		Map<Integer, Collection<? extends ISegment>> newRefs = new HashMap<Integer, Collection<? extends ISegment>>(oldData.getReferences().size());
		for(IReference oldRef : oldData.getReferences()){
			newRefs.put(oldRef.getID(), oldRef.getSegments());
		}
		
		// add the new description
		IReferent newData = new Referent(name, newRefs, null);
		if(newData == null) return null;
		
		IDesc newDesc = new Desc(oldDesc.getID(), ReferentRep.getInstance(), newData.calculatePosition(), newData, oldDesc.getMetaData());
		newDesc.getMetaData().addDesc(new MetaDesc<IOrigin>(OriginMetaRep.getInstance(), newDesc, Origin.USER_SPECIFIED));
		if(timing != null)
			newDesc.getMetaData().addDesc(new MetaDesc<ITiming>(TimingMetaRep.getInstance(), newDesc, timing));
		
		ReplaceDescriptionChange change = new ReplaceDescriptionChange(getName(), oldDesc, newDesc);
		return change.apply(source, provider);
	}

}
