/* Filename: AgreeResult.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Feb 11, 2010
 */
package nil.ucm.indications2.ui.agreement;

import org.eclipse.core.resources.IFile;

import edu.mit.story.core.measure.PairResult;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.ui 1.0.0
 */
public class AgreeResult extends PairResult implements IAgreeResult {
	
	private final int tokensOne;
	private final int tokensTwo;
	private final int tokenPairs;
	private final int tokensUnpairedOne;
	private final int tokensUnpairedTwo;

	private final int refsOne;
	private final int refsTwo;
	private final int refPairs;
	private final int refsUnpairedOne;
	private final int refsUnpairedTwo;
	
	private final int constsOne;
	private final int constsTwo;
	private final int constPairs;
	private final int constsUnpairedOne;
	private final int constsUnpairedTwo;
	
	private final int copularYY;
	private final int copularYN;
	private final int copularNY;
	private final int copularNN;
	
	private final int constNucNuc;
	private final int constNucMod;
	private final int constModNuc;
	private final int constModMod;
	
	private final int constDescDesc;
	private final int constDescDist;
	private final int constDistDesc;
	private final int constDistDist;
	
	private final int refsDescDesc;
	private final int refsDescDist;
	private final int refsDistDesc;
	private final int refsDistDist;


	/**
	 * TODO: Write comment
	 *
	 * @param target
	 * @param paired
	 * @param message
	 * @param e
	 * @since nil.ucm.indications2.ui 1.0.0
	 */
	public AgreeResult(IFile one, IFile two,
					   int tokensOne, int tokensTwo, int tokenPairs, int tokensUnpairedOne, int tokensUnpairedTwo,
					   int refsOne, int refsTwo, int refPairs, int refsUnpairedOne, int refsUnpairedTwo,
					   int constsOne, int constsTwo, int constPairs, int constsUnpairedOne, int constsUnpairedTwo,
					   int copularYY, int copularYN, int copularNY, int copularNN,
					   int constNucNuc, int constNucMod, int constModNuc, int constModMod,
					   int constDescDesc, int constDescDist, int constDistDesc, int constDistDist,
					   int refsDescDesc, int refsDescDist, int refsDistDesc, int refsDistDist) {
		super(one, two, "", null);
		
		this.tokensOne = checkNum(tokensOne);
		this.tokensTwo = checkNum(tokensTwo);
		this.tokenPairs = checkNum(tokenPairs);
		this.tokensUnpairedOne = checkNum(tokensUnpairedOne);
		this.tokensUnpairedTwo = checkNum(tokensUnpairedTwo);
		
		this.refsOne = checkNum(refsOne);
		this.refsTwo = checkNum(refsTwo);
		this.refPairs = checkNum(refPairs);
		this.refsUnpairedOne = checkNum(refsUnpairedOne);
		this.refsUnpairedTwo = checkNum(refsUnpairedTwo);

		this.constsOne = checkNum(constsOne);
		this.constsTwo = checkNum(constsTwo);
		this.constPairs = checkNum(constPairs);
		this.constsUnpairedOne = checkNum(constsUnpairedOne);
		this.constsUnpairedTwo = checkNum(constsUnpairedTwo);
		
		this.copularYY = checkNum(copularYY);
		this.copularYN = checkNum(copularYN);
		this.copularNY = checkNum(copularNY);
		this.copularNN = checkNum(copularNN);

		this.constNucNuc = checkNum(constNucNuc);
		this.constNucMod = checkNum(constNucMod);
		this.constModNuc = checkNum(constModNuc);
		this.constModMod = checkNum(constModMod);

		this.constDescDesc = checkNum(constDescDesc);
		this.constDescDist = checkNum(constDescDist);
		this.constDistDesc = checkNum(constDistDesc);
		this.constDistDist = checkNum(constDistDist);

		this.refsDescDesc = checkNum(refsDescDesc);
		this.refsDescDist = checkNum(refsDescDist);
		this.refsDistDesc = checkNum(refsDistDesc);
		this.refsDistDist = checkNum(refsDistDist);
		
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getTokensOne()
	 */
	public int getTokensOne() {
		return tokensOne;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getTokensPaired()
	 */
	public int getTokenPairs() {
		return tokenPairs;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getTokensTwo()
	 */
	public int getTokensTwo() {
		return tokensTwo;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getTokensUnpairedOne()
	 */
	public int getTokensUnpairedOne() {
		return tokensUnpairedOne;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getTokensUnpairedTwo()
	 */
	public int getTokensUnpairedTwo() {
		return tokensUnpairedTwo;
	}
	
	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getRefPairs()
	 */
	public int getRefPairs() {
		return refPairs;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getRefsOne()
	 */
	public int getRefsOne() {
		return refsOne;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getRefsTwo()
	 */
	public int getRefsTwo() {
		return refsTwo;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getRefsUnpairedOne()
	 */
	public int getRefsUnpairedOne() {
		return refsUnpairedOne;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getRefsUnpairedTwo()
	 */
	public int getRefsUnpairedTwo() {
		return refsUnpairedTwo;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getConstPairs()
	 */
	public int getConstPairs() {
		return constPairs;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getConstsOne()
	 */
	public int getConstsOne() {
		return constsOne;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getConstsTwo()
	 */
	public int getConstsTwo() {
		return constsTwo;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getConstsUnpairedOne()
	 */
	public int getConstsUnpairedOne() {
		return constsUnpairedOne;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getConstsUnpairedTwo()
	 */
	public int getConstsUnpairedTwo() {
		return constsUnpairedTwo;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getCopularNN()
	 */
	public int getCopularNN() {
		return copularNN;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getCopularNY()
	 */
	public int getCopularNY() {
		return copularNY;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getCopularYN()
	 */
	public int getCopularYN() {
		return copularYN;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getCopularYY()
	 */
	public int getCopularYY() {
		return copularYY;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getConstModMod()
	 */
	public int getConstModMod() {
		return constModMod;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getConstModNuc()
	 */
	public int getConstModNuc() {
		return constModNuc;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getConstNucMod()
	 */
	public int getConstNucMod() {
		return constNucMod;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getConstNucNuc()
	 */
	public int getConstNucNuc() {
		return constNucNuc;
	}
	
	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getConstModMod()
	 */
	public int getConstDistDist() {
		return constDistDist;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getConstModNuc()
	 */
	public int getConstDistDesc() {
		return constDistDesc;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getConstNucMod()
	 */
	public int getConstDescDist() {
		return constDescDist;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getConstNucNuc()
	 */
	public int getConstDescDesc() {
		return constDescDesc;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getRefsDescDesc()
	 */
	public int getRefsDescDesc() {
		return refsDescDesc;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getRefsDescDist()
	 */
	public int getRefsDescDist() {
		return refsDescDist;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getRefsDistDesc()
	 */
	public int getRefsDistDesc() {
		return refsDistDesc;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IAgreeResult#getRefsDistDist()
	 */
	public int getRefsDistDist() {
		return refsDistDist;
	}

	public static class AgreeResultBuilder {
		
		public int tokensOne;
		public int tokensTwo;
		public int tokenPairs;
		public int tokensUnpairedOne;
		public int tokensUnpairedTwo;
		
		public int refsOne;
		public int refsTwo;
		public int refPairs;
		public int refsUnpairedOne;
		public int refsUnpairedTwo;

		public int constsOne;
		public int constsTwo;
		public int constPairs;
		public int constsUnpairedOne;
		public int constsUnpairedTwo;
		
		public int copularYY;
		public int copularYN;
		public int copularNY;
		public int copularNN;
		
		public int constNucNuc;
		public int constNucMod;
		public int constModNuc;
		public int constModMod;

		public int constDescDesc;
		public int constDescDist;
		public int constDistDesc;
		public int constDistDist;
		
		public int refDescDesc;
		public int refDescDist;
		public int refDistDesc;
		public int refDistDist;


		public AgreeResult toResult(IFile one, IFile two){
			return new AgreeResult(one, two,
					               tokensOne, tokensTwo, tokenPairs, tokensUnpairedOne, tokensUnpairedTwo,
					               refsOne, refsTwo, refPairs, refsUnpairedOne, refsUnpairedTwo,
								   constsOne, constsTwo, constPairs, constsUnpairedOne, constsUnpairedTwo,
					               copularYY, copularYN, copularNY, copularNN,
								   constNucNuc, constNucMod, constModNuc, constModMod,
								   constDescDesc, constDescDist, constDistDesc, constDistDist,
								   refDescDesc, refDescDist, refDistDesc, refDistDist);
		}
		
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.Result#toString(boolean)
	 */
	@Override
	public String toString(boolean incRes) {
		StringBuilder sb = new StringBuilder();
		if(incRes){
			sb.append(getTarget().getName()).append('\t');
			sb.append(getSource().getName()).append('\t');
		}
		sb.append(Integer.toString(tokensOne)).append('\t');
		sb.append(Integer.toString(tokensTwo)).append('\t');
		sb.append(Integer.toString(tokenPairs)).append('\t');
		sb.append(Integer.toString(tokensUnpairedOne)).append('\t');
		sb.append(Integer.toString(tokensUnpairedTwo)).append('\t');
		
		sb.append(Integer.toString(refsOne)).append('\t');
		sb.append(Integer.toString(refsTwo)).append('\t');
		sb.append(Integer.toString(refPairs)).append('\t');
		sb.append(Integer.toString(refsUnpairedOne)).append('\t');
		sb.append(Integer.toString(refsUnpairedTwo)).append('\t');
		
		sb.append(Integer.toString(constsOne)).append('\t');
		sb.append(Integer.toString(constsTwo)).append('\t');
		sb.append(Integer.toString(constPairs)).append('\t');
		sb.append(Integer.toString(constsUnpairedOne)).append('\t');
		sb.append(Integer.toString(constsUnpairedTwo)).append('\t');
		
		sb.append(Integer.toString(copularYY)).append('\t');
		sb.append(Integer.toString(copularYN)).append('\t');
		sb.append(Integer.toString(copularNY)).append('\t');
		sb.append(Integer.toString(copularNN)).append('\t');
		
		sb.append(Integer.toString(constNucNuc)).append('\t');
		sb.append(Integer.toString(constNucMod)).append('\t');
		sb.append(Integer.toString(constModNuc)).append('\t');
		sb.append(Integer.toString(constModMod)).append('\t');

		sb.append(Integer.toString(constDescDesc)).append('\t');
		sb.append(Integer.toString(constDescDist)).append('\t');
		sb.append(Integer.toString(constDistDesc)).append('\t');
		sb.append(Integer.toString(constDistDist)).append('\t');

		sb.append(Integer.toString(refsDescDesc)).append('\t');
		sb.append(Integer.toString(refsDescDist)).append('\t');
		sb.append(Integer.toString(refsDistDesc)).append('\t');
		sb.append(Integer.toString(refsDistDist)).append('\t');
		
		return sb.toString();
	}

	public static String getHeaders(boolean incRes){
		StringBuilder sb = new StringBuilder();
		if(incRes){
			sb.append("Resource One").append('\t');
			sb.append("Resource Two").append('\t');
		}
		sb.append("Tokens/One").append('\t');
		sb.append("Tokens/Two").append('\t');
		sb.append("Token Pairs").append('\t');
		sb.append("Unpaired Tokens/One").append('\t');
		sb.append("Unpaired Tokens/Two").append('\t');
		
		sb.append("References/One").append('\t');
		sb.append("References/Two").append('\t');
		sb.append("Reference Pairs").append('\t');
		sb.append("Unpaired References/One").append('\t');
		sb.append("Unpaired References/Two").append('\t');
		
		sb.append("Constituents/One").append('\t');
		sb.append("Constituents/Two").append('\t');
		sb.append("Constituents Pairs").append('\t');
		sb.append("Unpaired Constituents/One").append('\t');
		sb.append("Unpaired Constituents/Two").append('\t');
		
		sb.append("Copular One=Y,Two=Y").append('\t');
		sb.append("Copular One=Y,Two=N").append('\t');
		sb.append("Copular One=N,Two=Y").append('\t');
		sb.append("Copular One=N,Two=N").append('\t');
		
		sb.append("Constituents One=Nuc,Two=Nuc").append('\t');
		sb.append("Constituents One=Nuc,Two=Mod").append('\t');
		sb.append("Constituents One=Mod,Two=Nuc").append('\t');
		sb.append("Constituents One=Mod,Two=Mod").append('\t');

		sb.append("Constituents One=Desc,Two=Desc").append('\t');
		sb.append("Constituents One=Desc,Two=Dist").append('\t');
		sb.append("Constituents One=Dist,Two=Desc").append('\t');
		sb.append("Constituents One=Dist,Two=Dist").append('\t');
		
		sb.append("References One=Desc,Two=Desc").append('\t');
		sb.append("References One=Desc,Two=Dist").append('\t');
		sb.append("References One=Dist,Two=Desc").append('\t');
		sb.append("References One=Dist,Two=Dist").append('\t');

		return sb.toString();
		
	}
}
