/* Filename: TimeResult.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Feb 9, 2010
 */
package nil.ucm.indications2.ui.agreement;

import org.eclipse.core.resources.IResource;

import edu.mit.story.core.measure.Result;
import edu.mit.story.core.rep.IRep;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.ui 1.0.0
 */
public class TimeResult extends Result implements ITimeResult {
	
	private final IRep rep;
	private final long total;
	private final long start;
	private final long end;
	private final long centroid;

	/**
	 * TODO: Write comment
	 *
	 * @param severity
	 * @param pluginId
	 * @param code
	 * @param message
	 * @param exception
	 * @since nil.ucm.indications2.ui 1.0.0
	 */
	public TimeResult(IResource target, IRep rep, long total, long start, long end, long centroid) {
		super(target);
		this.rep = rep;
		this.total = total;
		this.start = start;
		this.end = end;
		this.centroid = centroid;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IHasRep#getRep()
	 */
	public IRep getRep() {
		return rep;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ITimeResult#getLength()
	 */
	public long getTotal() {
		return total;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ITimeResult#getStart()
	 */
	public long getStart() {
		return start;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ITimeResult#getEnd()
	 */
	public long getEnd() {
		return end;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.ITimeResult#getCentroid()
	 */
	public long getCentroid() {
		return centroid;
	}
	
	public String toString(boolean incRes){
		StringBuilder sb = new StringBuilder();
		if(incRes) sb.append(getTarget().getName()).append('\t');
		sb.append(rep == null ? "all" : rep.getID()).append('\t');
		sb.append(Long.toString(total)).append('\t');
		sb.append(Long.toString(start)).append('\t');
		sb.append(Long.toString(end)).append('\t');
		sb.append(Long.toString(centroid)).append('\t');
		return sb.toString();
	}
	
	public static String getHeaders(String prefix, boolean incRes){
		StringBuilder sb = new StringBuilder();
		if(incRes) sb.append("Resource").append('\t');
		if(prefix.length() > 0) prefix += " ";
		sb.append(prefix + "Time Rep").append('\t');
		sb.append(prefix + "Time Total").append('\t');
		sb.append(prefix + "Time Start").append('\t');
		sb.append(prefix + "Time End").append('\t');
		sb.append(prefix + "Start Longest Period");
		return sb.toString();
	}

	public static class TimeResultBuilder {
		
		public IRep rep;
		public long total;
		public long start;
		public long end;
		public long centroid;
		
		public TimeResult toResult(IResource target){
			return new TimeResult(target, rep, total, start, end, centroid);
		}
		
	}

}
