/* Filename: CalculateAgreementHandler.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Feb 4, 2010
 */
package nil.ucm.indications2.ui.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import nil.ucm.indications2.core.rep.IndicationStructureRep;
import nil.ucm.indications2.ui.agreement.TimeCalculator;
import nil.ucm.indications2.ui.agreement.TimeResult;
import nil.ucm.indications2.ui.dialogs.SelectResourceDialog;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

import edu.mit.story.core.measure.IResult;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.ui 1.0.0
 */
public class CalculateTimesHandler extends AbstractHandler {

	/* 
	 * (non-Javadoc) @see org.eclipse.core.commands.IHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	public Object execute(ExecutionEvent event) throws ExecutionException {

		// extract active shell
		Shell shell = HandlerUtil.getActiveShell(event);
		if(shell == null) return null;
		
		// prompt user for projects
		SelectResourceDialog dialog = new SelectResourceDialog(shell, IResource.FILE | IResource.FOLDER | IResource.PROJECT);
		dialog.setBlockOnOpen(true);
		dialog.setTitle("Calculate Times");
		int result = dialog.open();
		if(result == Dialog.CANCEL) return null;
		
		// get the selected projects
		IResource one = dialog.getResourceOne();
		if(one == null) return null;
		
		// schedule calculation
		CalculationJob job = new CalculationJob(one);
		job.schedule();
		
		// must return null
		return null;
	}
	
	protected class CalculationJob extends Job {
		
		private final IResource r;

		/**
		 * TODO: Write comment
		 *
		 * @param name
		 * @since nil.ucm.indications2.ui 1.0.0
		 */
		public CalculationJob(IResource r) {
			super("Calculate times on " + r.getName());
			this.r = r;
			setPriority(LONG);
			setRule(r);
		}

		/* 
		 * (non-Javadoc) @see org.eclipse.core.runtime.jobs.Job#run(org.eclipse.core.runtime.IProgressMonitor)
		 */
		@Override
		protected IStatus run(IProgressMonitor monitor) {
			TimeCalculator calc = new TimeCalculator(IndicationStructureRep.getInstance());
			List<IResult> results = calc.calculate(r, monitor);
			
			results = new ArrayList<IResult>(results);
			Collections.sort(results, new Comparator<IResult>(){
				public int compare(IResult r1, IResult r2) {
					return r1.getTarget().getName().compareTo(r2.getTarget().getName());
				}});
			
			System.out.println(TimeResult.getHeaders(r.getName(), true));
			for(IResult r : results) System.out.println(r.toString(true));
			return Status.OK_STATUS;
		}
		
	}


	
	
}
