/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data.compare;

import edu.mit.jwi.data.compare.CommentComparator;
import edu.mit.jwi.data.compare.ICommentDetector;
import edu.mit.jwi.data.compare.ILineComparator;

public class IndexLineComparator
implements ILineComparator {
    private static final char spaceChar = ' ';
    private static IndexLineComparator fInstance;
    private CommentComparator fDetector = null;

    public static IndexLineComparator getInstance() {
        if (fInstance == null) {
            fInstance = new IndexLineComparator(CommentComparator.getInstance());
        }
        return fInstance;
    }

    protected IndexLineComparator(CommentComparator detector) {
        this.fDetector = detector;
    }

    public int compare(String s1, String s2) {
        boolean c2;
        boolean c1 = this.fDetector.isCommentLine(s1);
        if (c1 & (c2 = this.fDetector.isCommentLine(s2))) {
            return this.fDetector.compare(s1, s2);
        }
        if (c1 & !c2) {
            return -1;
        }
        if (!c1 & c2) {
            return 1;
        }
        int i1 = s1.indexOf(32);
        int i2 = s2.indexOf(32);
        if (i1 == -1) {
            i1 = s1.length();
        }
        if (i2 == -1) {
            i2 = s2.length();
        }
        String sub1 = s1.substring(0, i1).toLowerCase();
        String sub2 = s2.substring(0, i2).toLowerCase();
        return sub1.compareTo(sub2);
    }

    public ICommentDetector getCommentDetector() {
        return this.fDetector;
    }
}

