/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.eclipse.ui.internal.intro.impl.presentations.IntroLaunchBar;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class IntroPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ui.intro";
    private static IntroPlugin inst;
    private IntroLaunchBar launchBar;
    private long uiCreationStartTime;
    private ImageRegistry volatileImageRegistry;
    public static boolean DEBUG;
    public static boolean DEBUG_NO_BROWSER;

    static {
        DEBUG = false;
        DEBUG_NO_BROWSER = false;
    }

    public static IntroPlugin getDefault() {
        return inst;
    }

    public ImageRegistry getVolatileImageRegistry() {
        if (this.volatileImageRegistry == null) {
            this.volatileImageRegistry = this.createImageRegistry();
            this.initializeImageRegistry(this.volatileImageRegistry);
        }
        return this.volatileImageRegistry;
    }

    public void resetVolatileImageRegistry() {
        if (this.volatileImageRegistry != null) {
            this.volatileImageRegistry.dispose();
            this.volatileImageRegistry = null;
        }
    }

    public void closeLaunchBar() {
        if (this.launchBar != null) {
            this.launchBar.close();
            this.launchBar = null;
        }
    }

    public void setLaunchBar(IntroLaunchBar launchBar) {
        this.launchBar = launchBar;
    }

    public ExtensionPointManager getExtensionPointManager() {
        return ExtensionPointManager.getInst();
    }

    public IntroModelRoot getIntroModelRoot() {
        return this.getExtensionPointManager().getCurrentModel();
    }

    public static IIntroPart getIntro() {
        IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().getIntro();
        return introPart;
    }

    public static IIntroPart showIntro(boolean standby) {
        IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().showIntro(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), standby);
        return introPart;
    }

    public static boolean isIntroStandby() {
        return PlatformUI.getWorkbench().getIntroManager().isIntroStandby(IntroPlugin.getIntro());
    }

    public static void setIntroStandby(boolean standby) {
        PlatformUI.getWorkbench().getIntroManager().setIntroStandby(IntroPlugin.getIntro(), standby);
    }

    public static boolean closeIntro() {
        return PlatformUI.getWorkbench().getIntroManager().closeIntro(IntroPlugin.getIntro());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        inst = this;
        if (Log.logInfo) {
            Log.info("IntroPlugin - calling start on Intro bundle");
        }
        if (DEBUG = this.isDebugging()) {
            DEBUG_NO_BROWSER = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.ui.intro/flags/noBrowser"));
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.resetVolatileImageRegistry();
        super.stop(context);
    }

    public long gettUICreationStartTime() {
        return this.uiCreationStartTime;
    }

    public void setUICreationStartTime(long uiCreationStartTime) {
        this.uiCreationStartTime = uiCreationStartTime;
    }
}

