/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.update.core.model.FeatureModelFactory;
import org.eclipse.update.internal.core.InternalFeatureParser;
import org.eclipse.update.internal.core.LiteFeature;
import org.eclipse.update.internal.core.LiteFeatureFactory;
import org.eclipse.update.internal.core.UpdateCore;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DigestParser
extends DefaultHandler {
    private InternalFeatureParser featureParser = new InternalFeatureParser();
    private ArrayList featureModels;
    private SAXParser parser;
    private FeatureModelFactory factory;
    private String location;
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public DigestParser() {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            UpdateCore.log(e);
        }
        catch (SAXException e) {
            UpdateCore.log(e);
        }
    }

    public void init(FeatureModelFactory factory) {
        this.init(factory, null);
    }

    public void init(FeatureModelFactory factory, String location) {
        this.factory = factory;
        this.location = location;
        factory = new LiteFeatureFactory();
        this.featureModels = new ArrayList();
        this.featureParser.internalInit(factory, location);
    }

    public LiteFeature[] parse(InputStream in) throws SAXException, IOException {
        this.parser.parse(new InputSource(in), (DefaultHandler)this);
        return this.featureModels.toArray(new LiteFeature[this.featureModels.size()]);
    }

    public MultiStatus getStatus() {
        return this.featureParser.getStatus();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("digest")) {
            return;
        }
        if (localName.equals("feature")) {
            this.featureParser.internalInit(this.factory, this.location);
        }
        this.featureParser.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("digest")) {
            return;
        }
        this.featureParser.endElement(uri, localName, qName);
        if (localName.equals("feature")) {
            try {
                this.featureModels.add(this.featureParser.getFeatureModel());
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.featureParser.characters(ch, start, length);
    }

    public void error(SAXParseException ex) {
        this.featureParser.error(ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.featureParser.fatalError(ex);
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        this.featureParser.ignorableWhitespace(arg0, arg1, arg2);
    }
}

