/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.wizards;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.IMergeInputProvider;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.wizards.MergeWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MergeWizardMainPage
extends WizardPage {
    private Composite outerContainer;
    private Group descriptionGroup;
    private Label descriptionImage;
    private Label descriptionLabel;
    private Button bestPracticesButton;
    private IMergeInputProvider[] mergeInputProviders;
    private IMergeInputProvider selectedMergeInputProvider;
    private IDialogSettings settings;
    private static final String LAST_INPUT_PROVIDER = "MergeWizardMainPage.lastInputProvider";

    public MergeWizardMainPage(String pageName, String title, ImageDescriptor titleImage, IMergeInputProvider[] mergeInputProviders) {
        super(pageName, title, titleImage);
        this.mergeInputProviders = mergeInputProviders;
        this.setPageComplete(true);
        this.settings = Activator.getDefault().getDialogSettings();
    }

    public void createControl(Composite parent) {
        this.outerContainer = new Composite(parent, 0);
        this.outerContainer.setLayout((Layout)new GridLayout());
        this.outerContainer.setLayoutData((Object)new GridData(768));
        Group inputGroup = new Group(this.outerContainer, 0);
        inputGroup.setText(Messages.MergeWizardMainPage_mergeInput);
        GridLayout inputLayout = new GridLayout();
        inputLayout.numColumns = 1;
        inputGroup.setLayout((Layout)inputLayout);
        inputGroup.setLayoutData((Object)new GridData(768));
        this.getInputProviders(inputGroup);
        this.createDescriptionArea();
        this.bestPracticesButton = new Button(this.outerContainer, 32);
        this.bestPracticesButton.setText(Messages.MergeWizardMainPage_bestPractice);
        this.bestPracticesButton.setSelection(true);
        this.bestPracticesButton.setVisible(this.selectedMergeInputProvider.showBestPracticesPage());
        this.setMessage(Messages.MergeWizardMainPage_specifyType);
        this.setControl((Control)this.outerContainer);
    }

    private void createDescriptionArea() {
        GridData data;
        boolean needsRedraw;
        boolean bl = needsRedraw = this.descriptionGroup != null;
        if (this.descriptionGroup == null) {
            this.descriptionGroup = new Group(this.outerContainer, 0);
            GridLayout descriptionLayout = new GridLayout();
            descriptionLayout.numColumns = 1;
            this.descriptionGroup.setLayout((Layout)descriptionLayout);
            this.descriptionGroup.setLayoutData((Object)new GridData(1808));
        }
        this.descriptionGroup.setText(this.selectedMergeInputProvider.getText());
        if (this.descriptionLabel != null) {
            this.descriptionLabel.dispose();
        }
        if (this.descriptionImage != null) {
            this.descriptionImage.dispose();
        }
        if (this.selectedMergeInputProvider.getImage() != null) {
            this.descriptionImage = new Label((Composite)this.descriptionGroup, 0);
            data = new GridData(64);
            this.descriptionImage.setLayoutData((Object)data);
            this.descriptionImage.setImage(this.selectedMergeInputProvider.getImage());
        }
        this.descriptionLabel = new Label((Composite)this.descriptionGroup, 64);
        data = new GridData(1808);
        data.widthHint = 500;
        this.descriptionLabel.setLayoutData((Object)data);
        this.descriptionLabel.setText(this.selectedMergeInputProvider.getDescription());
        if (needsRedraw) {
            this.descriptionGroup.layout(true);
            this.descriptionGroup.redraw();
        }
    }

    private void getInputProviders(Group inputGroup) {
        final MergeWizard mergeWizard = (MergeWizard)this.getWizard();
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                Integer integer = (Integer)button.getData();
                MergeWizardMainPage.this.selectedMergeInputProvider = MergeWizardMainPage.this.mergeInputProviders[integer];
                MergeWizardMainPage.this.settings.put(MergeWizardMainPage.LAST_INPUT_PROVIDER, MergeWizardMainPage.this.selectedMergeInputProvider.getText());
                MergeWizardMainPage.this.createDescriptionArea();
                MergeWizardMainPage.this.bestPracticesButton.setVisible(MergeWizardMainPage.this.selectedMergeInputProvider.showBestPracticesPage());
                boolean needsChecks = mergeWizard.getBestPracticesPage().needsChecks();
                mergeWizard.getBestPracticesPage().setNeedsChecks(false);
                MergeWizardMainPage.this.setPageComplete(true);
                mergeWizard.getBestPracticesPage().setNeedsChecks(needsChecks);
            }
        };
        String lastInputProvider = this.settings.get(LAST_INPUT_PROVIDER);
        int i = 0;
        while (i < this.mergeInputProviders.length) {
            Button inputButton = new Button((Composite)inputGroup, 16);
            inputButton.setText("&" + this.mergeInputProviders[i].getText());
            inputButton.setData((Object)new Integer(i));
            if (!this.mergeInputProviders[i].enabledForMultipleSelection() && mergeWizard.getResources().length > 1) {
                inputButton.setEnabled(false);
            } else {
                if (lastInputProvider != null && this.mergeInputProviders[i].getText().equals(lastInputProvider)) {
                    inputButton.setSelection(true);
                    this.selectedMergeInputProvider = this.mergeInputProviders[i];
                }
                if (lastInputProvider == null && i == 0) {
                    inputButton.setSelection(true);
                    this.selectedMergeInputProvider = this.mergeInputProviders[i];
                }
            }
            inputButton.addSelectionListener((SelectionListener)selectionListener);
            ++i;
        }
        if (this.selectedMergeInputProvider == null) {
            this.selectedMergeInputProvider = this.mergeInputProviders[0];
        }
    }

    public IMergeInputProvider getSelectedMergeInputProvider() {
        return this.selectedMergeInputProvider;
    }

    public boolean showBestPracticesPage() {
        return this.selectedMergeInputProvider.showBestPracticesPage() && this.bestPracticesButton.getSelection();
    }
}

