/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.wizards;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ResolveConflictWizardPage
extends WizardPage {
    private IResource[] resources;
    private Button markResolvedButton;
    private Button chooseUserVersionButton;
    private Button chooseIncomingVersionButton;
    private Button chooseBaseVersionButton;
    private IDialogSettings settings;
    private boolean textConflicts;
    private boolean propertyConflicts;
    private boolean treeConflicts;
    private static final String LAST_CHOICE = "ResolveConflictDialog.lastChoice";

    public ResolveConflictWizardPage(String pageName, IResource[] resources) {
        super(pageName, Messages.ResolveConflictWizardPage_resolveConflict, Activator.getDefault().getImageDescriptor("svn_wizban.png"));
        this.resources = resources;
        this.settings = Activator.getDefault().getDialogSettings();
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout outerLayout = new GridLayout();
        outerLayout.numColumns = 1;
        outerContainer.setLayout((Layout)outerLayout);
        outerContainer.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(outerContainer, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        if (this.resources.length == 1) {
            label.setText(String.valueOf(Messages.ResolveConflictWizardPage_file) + this.resources[0].getFullPath().makeRelative().toOSString());
        } else {
            label.setText(Messages.ResolveConflictWizardPage_multipleSelected);
        }
        data = new GridData();
        data.widthHint = 500;
        label.setLayoutData((Object)data);
        if (this.treeConflicts) {
            new Label(composite, 0);
            Label treeLabel1 = new Label(composite, 64);
            if (this.resources.length > 1) {
                treeLabel1.setText(Messages.ResolveConflictWizardPage_messageMultiple);
            } else {
                treeLabel1.setText(Messages.ResolveConflictWizardPage_message);
            }
            data = new GridData();
            data.widthHint = 500;
            treeLabel1.setLayoutData((Object)data);
        } else if (this.propertyConflicts) {
            new Label(composite, 0);
            Label propertyLabel1 = new Label(composite, 64);
            if (this.resources.length > 1) {
                propertyLabel1.setText(Messages.ResolveConflictWizardPage_messagePropertyMultiple);
            } else {
                propertyLabel1.setText(Messages.ResolveConflictWizardPage_messageProperty);
            }
            data = new GridData();
            data.widthHint = 500;
            propertyLabel1.setLayoutData((Object)data);
        }
        new Label(composite, 0);
        Group conflictGroup = new Group(composite, 0);
        conflictGroup.setText(Messages.ResolveConflictWizardPage_question);
        GridLayout conflictLayout = new GridLayout();
        conflictLayout.numColumns = 1;
        conflictGroup.setLayout((Layout)conflictLayout);
        data = new GridData(1808);
        conflictGroup.setLayoutData((Object)data);
        this.markResolvedButton = new Button((Composite)conflictGroup, 16);
        this.markResolvedButton.setText(Messages.ResolveConflictWizardPage_conflictsResolved);
        if (this.treeConflicts) {
            Label treeLabel2 = new Label((Composite)conflictGroup, 0);
            treeLabel2.setText(Messages.ResolveConflictWizardPage_doNotApplyTreeConflicts);
        } else if (this.propertyConflicts) {
            Label propertyLabel2 = new Label((Composite)conflictGroup, 0);
            propertyLabel2.setText(Messages.ResolveConflictWizardPage_doNotApplyProperties);
        }
        this.chooseUserVersionButton = new Button((Composite)conflictGroup, 16);
        this.chooseUserVersionButton.setText(Messages.ResolveConflictWizardPage_useMine);
        this.chooseIncomingVersionButton = new Button((Composite)conflictGroup, 16);
        this.chooseIncomingVersionButton.setText(Messages.ResolveConflictWizardPage_useIncoming);
        this.chooseBaseVersionButton = new Button((Composite)conflictGroup, 16);
        this.chooseBaseVersionButton.setText(Messages.ResolveConflictWizardPage_useBase);
        int lastChoice = 6;
        try {
            lastChoice = this.settings.getInt(LAST_CHOICE);
        }
        catch (Exception exception) {}
        if (lastChoice == 6) {
            this.markResolvedButton.setSelection(true);
        } else if (lastChoice == 3) {
            this.chooseUserVersionButton.setSelection(true);
        } else if (lastChoice == 2) {
            this.chooseIncomingVersionButton.setSelection(true);
        } else if (lastChoice == 1) {
            this.chooseBaseVersionButton.setSelection(true);
        }
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ResolveConflictWizardPage.this.markResolvedButton.getSelection()) {
                    ResolveConflictWizardPage.this.settings.put(ResolveConflictWizardPage.LAST_CHOICE, 6);
                } else if (ResolveConflictWizardPage.this.chooseUserVersionButton.getSelection()) {
                    ResolveConflictWizardPage.this.settings.put(ResolveConflictWizardPage.LAST_CHOICE, 3);
                } else if (ResolveConflictWizardPage.this.chooseIncomingVersionButton.getSelection()) {
                    ResolveConflictWizardPage.this.settings.put(ResolveConflictWizardPage.LAST_CHOICE, 2);
                } else if (ResolveConflictWizardPage.this.chooseBaseVersionButton.getSelection()) {
                    ResolveConflictWizardPage.this.settings.put(ResolveConflictWizardPage.LAST_CHOICE, 1);
                }
            }
        };
        this.markResolvedButton.addSelectionListener((SelectionListener)selectionListener);
        this.chooseUserVersionButton.addSelectionListener((SelectionListener)selectionListener);
        this.chooseIncomingVersionButton.addSelectionListener((SelectionListener)selectionListener);
        this.chooseBaseVersionButton.addSelectionListener((SelectionListener)selectionListener);
        if (this.resources.length == 1) {
            this.setMessage(String.valueOf(Messages.ResolveConflictWizardPage_decide) + this.resources[0].getName() + ".");
        } else {
            this.setMessage(Messages.ResolveConflictWizardPage_decideMultiple);
        }
        this.setControl((Control)outerContainer);
    }

    public int getConflictResolution() {
        int resolution = 0;
        if (this.markResolvedButton.getSelection()) {
            resolution = 6;
        } else if (this.chooseIncomingVersionButton.getSelection()) {
            resolution = 2;
        } else if (this.chooseUserVersionButton.getSelection()) {
            resolution = 3;
        } else if (this.chooseBaseVersionButton.getSelection()) {
            resolution = 1;
        }
        return resolution;
    }

    public void setTextConflicts(boolean textConflicts) {
        this.textConflicts = textConflicts;
    }

    public void setPropertyConflicts(boolean propertyConflicts) {
        this.propertyConflicts = propertyConflicts;
    }

    public void setTreeConflicts(boolean treeConflicts) {
        this.treeConflicts = treeConflicts;
    }
}

