/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.pos;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.PosData;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;

public class PosTag
extends PosData
implements IPosTag {
    private final IDesc token;

    public PosTag(IDesc token, ITag tag, boolean isAux) {
        super(tag, isAux);
        if (!TokenRep.getInstance().isType((IHasRep)token) && !CollocRep.getInstance().isType((IHasRep)token)) {
            throw new IllegalArgumentException();
        }
        this.token = token;
    }

    public IDesc getWord() {
        return this.token;
    }

    public IHasPosition calculatePosition() {
        return this.token;
    }

    public IHasPosition getDisplayPosition() {
        return this.token;
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        IDesc newToken = model.getData().getDescriptions(this.token.getRep()).getDescription(this.token.getID());
        if (newToken == null) {
            return null;
        }
        if (newToken == this.token) {
            return this;
        }
        return new PosTag(newToken, this.getTag(), this.isAuxiliary());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isAuxiliary() ? 1231 : 1237);
        result = 31 * result + this.getTag().hashCode();
        result = 31 * result + this.token.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PosTag other = (PosTag)obj;
        if (this.isAuxiliary() != other.isAuxiliary()) {
            return false;
        }
        if (!this.getTag().equals(other.getTag())) {
            return false;
        }
        return this.token.equals(other.token);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (this == tgtData) {
            return true;
        }
        if (!IPosTag.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        IPosTag tgtPos = (IPosTag)tgtData;
        if (this.isAuxiliary() != tgtPos.isAuxiliary()) {
            return false;
        }
        if (!this.getTag().equals(tgtPos.getTag())) {
            return false;
        }
        return this.token.equals(tgtPos.getWord(), model);
    }
}

