/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.stem.algorithm;

import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.stem.algorithm.IStemmer;
import edu.mit.story.core.algorithm.AbstractAlgorithm;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStemmer
extends AbstractAlgorithm
implements IStemmer {
    public static final String SUFFIX_ches = "ches";
    public static final String SUFFIX_ed = "ed";
    public static final String SUFFIX_es = "es";
    public static final String SUFFIX_est = "est";
    public static final String SUFFIX_er = "er";
    public static final String SUFFIX_ful = "ful";
    public static final String SUFFIX_ies = "ies";
    public static final String SUFFIX_ing = "ing";
    public static final String SUFFIX_men = "men";
    public static final String SUFFIX_s = "s";
    public static final String SUFFIX_ses = "ses";
    public static final String SUFFIX_shes = "shes";
    public static final String SUFFIX_xes = "xes";
    public static final String SUFFIX_zes = "zes";
    public static final String ENDING_null = "";
    public static final String ENDING_ch = "ch";
    public static final String ENDING_e = "e";
    public static final String ENDING_man = "man";
    public static final String ENDING_s = "s";
    public static final String ENDING_sh = "sh";
    public static final String ENDING_x = "x";
    public static final String ENDING_y = "y";
    public static final String ENDING_z = "z";
    String[][] nounMappings = new String[][]{{"s", ""}, {"ses", "s"}, {"xes", "x"}, {"zes", "z"}, {"ches", "ch"}, {"shes", "sh"}, {"men", "man"}, {"ies", "y"}};
    String[][] verbMappings = new String[][]{{"s", ""}, {"ies", "y"}, {"es", "e"}, {"es", ""}, {"ed", "e"}, {"ed", ""}, {"ing", "e"}, {"ing", ""}};
    String[][] adjMappings = new String[][]{{"er", "e"}, {"er", ""}, {"est", "e"}, {"est", ""}};

    @Override
    public SortedSet<String> getStems(String word, ITag tag) {
        if (tag.isNoun()) {
            return this.stripNounSuffix(word);
        }
        if (tag.isVerb()) {
            return this.stripVerbSuffix(word);
        }
        if (tag.isAdjective()) {
            this.stripAdjectiveSuffix(word);
        }
        return null;
    }

    protected SortedSet<String> stripNounSuffix(String noun) {
        int idx;
        if (noun == null) {
            return null;
        }
        String word = noun;
        boolean endsWithFUL = false;
        if (noun.endsWith(SUFFIX_ful)) {
            endsWithFUL = true;
            idx = word.lastIndexOf(SUFFIX_ful);
            word = noun.substring(0, idx);
        }
        TreeSet<String> result = null;
        String[][] stringArray = this.nounMappings;
        int n = this.nounMappings.length;
        int n2 = 0;
        while (n2 < n) {
            String[] mapping = stringArray[n2];
            if (word.endsWith(mapping[0])) {
                idx = word.lastIndexOf(mapping[0]);
                StringBuffer stem = new StringBuffer();
                int i = 0;
                while (i < idx) {
                    stem.append(word.charAt(i));
                    ++i;
                }
                stem.append(mapping[1]);
                if (endsWithFUL) {
                    stem.append(SUFFIX_ful);
                }
                if (result == null) {
                    result = new TreeSet<String>();
                }
                result.add(stem.toString());
            }
            ++n2;
        }
        return result;
    }

    protected SortedSet<String> stripVerbSuffix(String word) {
        if (word == null) {
            return null;
        }
        TreeSet<String> result = null;
        String[][] stringArray = this.verbMappings;
        int n = this.verbMappings.length;
        int n2 = 0;
        while (n2 < n) {
            String[] mapping = stringArray[n2];
            if (word.endsWith(mapping[0])) {
                int idx = word.lastIndexOf(mapping[0]);
                StringBuffer stem = new StringBuffer();
                int i = 0;
                while (i < idx) {
                    stem.append(word.charAt(i));
                    ++i;
                }
                stem.append(mapping[1]);
                if (result == null) {
                    result = new TreeSet<String>();
                }
                result.add(stem.toString());
            }
            ++n2;
        }
        return result;
    }

    protected SortedSet<String> stripAdjectiveSuffix(String word) {
        if (word == null) {
            return null;
        }
        TreeSet<String> result = null;
        String[][] stringArray = this.adjMappings;
        int n = this.adjMappings.length;
        int n2 = 0;
        while (n2 < n) {
            String[] mapping = stringArray[n2];
            if (word.endsWith(mapping[0])) {
                int idx = word.lastIndexOf(mapping[0]);
                StringBuffer stem = new StringBuffer();
                int i = 0;
                while (i < idx) {
                    stem.append(word.charAt(i));
                    ++i;
                }
                stem.append(mapping[1]);
                if (result == null) {
                    result = new TreeSet<String>();
                }
                result.add(stem.toString());
            }
            ++n2;
        }
        return result;
    }
}

