/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.stem.rules;

import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.stem.problems.BuggyStemProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuggyStemRule
extends AbstractBuildRule {
    public static final Set<String> buggyStems = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("multiple stems", "n/a")));

    public BuggyStemRule() {
        super(StemRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        HashSet<IDesc> buggy = new HashSet<IDesc>();
        for (IDesc stemDesc : model.getData().getDescriptions(StemRep.getInstance())) {
            IStem stem = (IStem)stemDesc.getData();
            if (!buggyStems.contains(stem.getStem())) continue;
            buggy.add(stemDesc);
        }
        if (buggy.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc d : buggy) {
            result.add((Object)new BuggyStemProblem(d, this.getID()));
        }
        return result;
    }
}

