/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.tag;

import edu.mit.parsing.core.rep.tag.ITagData;
import edu.mit.parsing.core.rep.tag.TagRep;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.core.rep.tag.tagset.Tag;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.model.IStoryModel;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagData
extends SegmentSet
implements ITagData {
    private final String tagID;

    public TagData(String tagID, Collection<? extends ISegment> segs) {
        super(segs);
        if (tagID == null) {
            throw new NullPointerException();
        }
        if ((tagID = tagID.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        this.tagID = tagID;
    }

    @Override
    public String getTagID() {
        return this.tagID;
    }

    public ITagData recalculate(IDesc container, IStoryModel model) {
        ISegmentSet newSegments = super.recalculate(container, model);
        if (newSegments == this) {
            return this;
        }
        if (newSegments == null) {
            return null;
        }
        return new TagData(this.getTagID(), (Collection<? extends ISegment>)newSegments);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        ITagset tgtTagset;
        if (this == tgtData) {
            return true;
        }
        if (!ITagData.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        ITagset srcTagset = TagRep.getTagset(model.getSourceModel());
        if (!srcTagset.equals(tgtTagset = TagRep.getTagset(model.getTargetModel()))) {
            return false;
        }
        ITagData tgtTagData = (ITagData)tgtData;
        if (!Tag.equalIDs(this.getTagID(), tgtTagData.getTagID())) {
            return false;
        }
        return super.equals(tgtData, model);
    }
}

