/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.tag.tagset.manager;

import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.core.rep.tag.tagset.handlers.TagsetHandler;
import edu.mit.parsing.core.rep.tag.tagset.manager.ITagsetDescriptor;
import edu.mit.parsing.core.rep.tag.tagset.manager.ITagsetManager;
import edu.mit.parsing.core.rep.tag.tagset.manager.TagsetDescriptor;
import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.util.XMLUtils;
import edu.mit.story.core.xml.IHasParserHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsetManager
extends ChangeNotifier
implements ITagsetManager,
IResourceChangeListener {
    private Map<IFile, ITagsetDescriptor> tagsetMap;
    public static final String MEMENTO_TYPE_PARENT = "tagsets";
    public static final String MEMENTO_TYPE_CHILD = "tagset";
    public static final String MEMENTO_KEY_FILE = "file";
    public static final String SAVE_BASENAME = "tagsets";
    public static final IPath SAVE_BASENAME_PATH = new Path("tagsets");

    public void init() {
        this.tagsetMap = new HashMap<IFile, ITagsetDescriptor>();
    }

    public boolean isInitialized() {
        return this.tagsetMap != null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        final LinkedList tagsetsRemoved = new LinkedList();
        final LinkedList tagsetsModified = new LinkedList();
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource r = delta.getResource();
                        if (r.getType() != 1) {
                            return true;
                        }
                        IFile f = (IFile)r;
                        if (TagsetManager.isTagset(f)) {
                            switch (delta.getKind()) {
                                case 2: {
                                    tagsetsRemoved.add(f);
                                    break;
                                }
                                case 1: 
                                case 4: {
                                    tagsetsModified.add(f);
                                }
                            }
                        }
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        for (IFile f : tagsetsRemoved) {
            this.tagsetRemoved(f);
        }
        for (IFile f : tagsetsModified) {
            this.tagsetModified(f);
        }
    }

    protected void tagsetRemoved(IFile file) {
        this.tagsetMap.remove(file);
        this.notifyChangeListeners(file);
    }

    protected void tagsetModified(IFile file) {
        this.tagsetMap.remove(file);
        ITagset tagset = null;
        TagsetHandler handler = new TagsetHandler();
        try {
            XMLUtils.parse((IHasParserHandler)handler, (IFile)file);
            tagset = handler.getElement();
        }
        catch (Throwable t) {
            Status status = new Status(1, "edu.mit.parsing.core", "Problem parsing tagset file: " + file.getFullPath().toPortableString(), t);
            ParsingPlugin.getDefault().getLog().log((IStatus)status);
        }
        if (tagset == null) {
            return;
        }
        TagsetDescriptor desc = new TagsetDescriptor(tagset, file.getProject().getName(), file.getProjectRelativePath().toPortableString());
        this.tagsetMap.put(file, desc);
        this.notifyChangeListeners(file);
    }

    public ITagsetDescriptor getDescriptor(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        if ((id = id.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        for (ITagsetDescriptor d : this.tagsetMap.values()) {
            if (!id.equalsIgnoreCase(d.getID())) continue;
            return d;
        }
        return null;
    }

    @Override
    public ITagset createByPath(String path) {
        ITagsetDescriptor desc = this.getDescriptorByPath(path);
        return desc == null ? null : (ITagset)desc.create();
    }

    @Override
    public ITagsetDescriptor getDescriptorByPath(String pathStr) {
        Path path = new Path(pathStr);
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        return this.tagsetMap.get(file);
    }

    public ITagset create(String id) {
        ITagsetDescriptor desc = this.getDescriptor(id);
        return desc == null ? null : (ITagset)desc.create();
    }

    public List<ITagsetDescriptor> getDescriptors() {
        return new ArrayList<ITagsetDescriptor>(this.tagsetMap.values());
    }

    public static boolean isTagset(IFile r) {
        return r.getName().toLowerCase().endsWith(".tagset");
    }

    protected void writeState(File f) throws CoreException {
        XMLMemento parent = XMLMemento.createWriteRoot((String)"tagsets");
        for (Map.Entry<IFile, ITagsetDescriptor> e : this.tagsetMap.entrySet()) {
            IMemento child = parent.createChild(MEMENTO_TYPE_CHILD);
            child.putString(MEMENTO_KEY_FILE, e.getKey().getFullPath().toPortableString());
        }
        try {
            parent.save((Writer)new BufferedWriter(new FileWriter(f)));
        }
        catch (IOException e) {
            Status status = new Status(4, "edu.mit.parsing.core", "Problem writing to file " + f.getAbsolutePath(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    protected void readState(File f) {
        XMLMemento parent = null;
        try {
            BufferedReader r = new BufferedReader(new FileReader(f));
            try {
                parent = XMLMemento.createReadRoot((Reader)r);
            }
            catch (WorkbenchException e) {
                Status status = new Status(4, "edu.mit.parsing.core", "Problem reading memento from file " + f.getAbsolutePath(), (Throwable)e);
                ParsingPlugin.getDefault().getLog().log((IStatus)status);
                return;
            }
            ((Reader)r).close();
        }
        catch (IOException e) {
            Status status = new Status(4, "edu.mit.parsing.core", "Problem closing file " + f.getAbsolutePath(), (Throwable)e);
            ParsingPlugin.getDefault().getLog().log((IStatus)status);
            return;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IMemento[] iMementoArray = parent.getChildren(MEMENTO_TYPE_CHILD);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IMemento m = iMementoArray[n2];
            IResource res = root.findMember((IPath)new Path(m.getString(MEMENTO_KEY_FILE)));
            IFile iFile = file = res instanceof IFile ? (IFile)res : null;
            if (file != null) {
                this.tagsetModified(file);
            }
            ++n2;
        }
    }

    protected static final String makeSaveFileName(String basename, int saveNumber) {
        return String.valueOf(basename) + '-' + Integer.toString(saveNumber);
    }

    public void load(ISavedState savedState) {
        if (savedState == null) {
            return;
        }
        IPath location = savedState.lookup(SAVE_BASENAME_PATH);
        if (location != null) {
            File savedStateFile = ParsingPlugin.getDefault().getStateLocation().append(location).toFile();
            this.readState(savedStateFile);
        }
        savedState.processResourceChangeEvents((IResourceChangeListener)this);
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void saving(ISaveContext context) throws CoreException {
        context.needDelta();
        String saveFileName = TagsetManager.makeSaveFileName("tagsets", context.getSaveNumber());
        File savedStateFile = ParsingPlugin.getDefault().getStateLocation().append(saveFileName).toFile();
        this.writeState(savedStateFile);
        context.map(SAVE_BASENAME_PATH, (IPath)new Path(saveFileName));
        context.needSaveNumber();
    }

    public void doneSaving(ISaveContext context) {
        String oldFileName = TagsetManager.makeSaveFileName("tagsets", context.getPreviousSaveNumber());
        File f = ParsingPlugin.getDefault().getStateLocation().append(oldFileName).toFile();
        f.delete();
    }

    public void rollback(ISaveContext context) {
        String saveFileName = TagsetManager.makeSaveFileName("tagsets", context.getSaveNumber());
        File f = ParsingPlugin.getDefault().getStateLocation().append(saveFileName).toFile();
        f.delete();
    }
}

