/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.handlers;

import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.ui.dialogs.CorefSelectionDialog;
import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.semantics.core.rep.archetype.ArchetypalReferent;
import edu.mit.semantics.core.rep.archetype.Archetype;
import edu.mit.semantics.core.rep.archetype.ArchetypeRep;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateArchetypeHandler
extends AbstractHandler {
    public static final String PARAM_Archtype = "edu.mit.semantics.ui.commandParameter.createArchetype.Archetype";

    public void setEnabled(Object context) {
        EvaluationContext evalContext;
        Object var;
        if (context instanceof EvaluationContext && (var = (evalContext = (EvaluationContext)context).getVariable("activeEditor")) instanceof IStoryEditor) {
            IStoryEditor editor = (IStoryEditor)var;
            IDescSet tokens = ParsingUtils.getSelectedTokens((IStoryEditor)editor);
            IDescSet refs = editor.getStoryModel().getData().getDescriptions(RefExpRep.getInstance()).closedSet((IHasPosition)tokens);
            this.setBaseEnabled(!refs.isEmpty());
            return;
        }
        this.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String message;
        Date start = new Date();
        IStoryEditor editor = (IStoryEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!editor.getStoryModel().supports(RefExpRep.getInstance())) {
            return null;
        }
        Archetype type = (Archetype)event.getObjectParameterForExecution(PARAM_Archtype);
        if (type == null) {
            type = Archetype.UNKNOWN;
        }
        IHasPosition selection = editor.getSelectedRange();
        IDesc corefD = null;
        IDescSet refExpDs = editor.getStoryModel().getData().getDescriptions(RefExpRep.getInstance()).closedSet(selection);
        if (refExpDs.size() == 1) {
            corefD = CorefRep.findParent((IRefExp)((IRefExp)((IDesc)refExpDs.first()).getData()), (IStoryModel)editor.getStoryModel());
        }
        if (corefD == null && (corefD = (IDesc)CorefSelectionDialog.open((IStoryEditor)editor, null, (String)(message = "Please select a referent to mark as an " + type.getName()), (IHasPosition)selection, (boolean)false)) == null) {
            return null;
        }
        ArchetypalReferent arch = new ArchetypalReferent(type, corefD);
        long id = editor.getStoryModel().getNextID();
        Desc archD = new Desc(id, ArchetypeRep.getInstance(), arch.calculatePosition(), (IData)arch, null);
        archD.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)archD, (IMetaData)Origin.USER_SPECIFIED));
        archD.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)archD, (IMetaData)new Timing(start, "user")));
        AddDescriptionsChange change = new AddDescriptionsChange((IDesc)archD);
        editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        return null;
    }
}

