/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions.generic;

import edu.mit.story.ui.StoryUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.AbstractTreeViewer;

public class CollapseAllAction
extends Action {
    private final AbstractTreeViewer viewer;
    private final int toLevel;

    public CollapseAllAction(AbstractTreeViewer viewer) {
        this(viewer, 0);
    }

    public CollapseAllAction(AbstractTreeViewer viewer, int toLevel) {
        if (viewer == null) {
            throw new NullPointerException();
        }
        this.viewer = viewer;
        this.toLevel = Math.max(1, toLevel);
        this.setToolTipText("Collapse All");
        this.setActionDefinitionId("org.eclipse.ui.navigate.collapseAll");
        this.setImageDescriptor(StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("elcl16/collapse_all.gif"));
        this.setId("collapseAll");
    }

    public void run() {
        if (this.viewer.getControl() == null) {
            return;
        }
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        try {
            this.viewer.getControl().setRedraw(false);
            this.viewer.collapseAll();
            if (this.toLevel > 0) {
                this.viewer.expandToLevel(this.toLevel);
            }
        }
        finally {
            this.viewer.getControl().setRedraw(true);
        }
    }
}

