/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditNoteDialog
extends StatusDialog {
    protected static final IStatus STATUS_EMPTY_NOTE = new Status(4, "edu.mit.story.ui", "The note may not be empty");
    protected static final IStatus STATUS_UNMODIFIED_NOTE = new Status(4, "edu.mit.story.ui", "The note has not been changed");
    protected String originalNote;
    protected String currentNote;
    protected Text textWidget;

    public EditNoteDialog(Shell parent) {
        this(parent, "");
    }

    public EditNoteDialog(Shell parent, String note) {
        super(parent);
        this.currentNote = this.originalNote = "";
        this.setNote(note);
    }

    public void setNote(String note) {
        if (note == null) {
            throw new NullPointerException();
        }
        this.originalNote = note;
        this.currentNote = note;
    }

    public String getOriginalNote() {
        return this.originalNote;
    }

    public String getCurrentNote() {
        return this.currentNote;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.textWidget = new Text(dialogArea, 2114);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(100);
        this.textWidget.setLayoutData((Object)gd);
        this.textWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditNoteDialog.this.currentNote = EditNoteDialog.this.textWidget.getText();
                EditNoteDialog.this.updateControls();
            }
        });
        this.textWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.character == '\r') {
                    EditNoteDialog.this.okPressed();
                }
            }
        });
        this.updateControls();
        return dialogArea;
    }

    protected void updateControls() {
        String currentText = this.textWidget.getText();
        if (!currentText.equals(this.currentNote)) {
            this.textWidget.setText(this.currentNote);
        }
        if (this.currentNote.equals(this.originalNote)) {
            this.updateStatus(STATUS_UNMODIFIED_NOTE);
            return;
        }
        if (this.currentNote.length() == 0) {
            this.updateStatus(STATUS_EMPTY_NOTE);
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    protected boolean isResizable() {
        return true;
    }

    public static String createNote(Shell shell) {
        return EditNoteDialog.editNote(shell, null);
    }

    public static String editNote(Shell shell, String note) {
        String title;
        String string = title = note == null ? "Create Note" : "Edit Note";
        if (note == null) {
            note = "";
        }
        EditNoteDialog dialog = new EditNoteDialog(shell, note);
        dialog.setBlockOnOpen(true);
        dialog.setTitle(title);
        dialog.open();
        return dialog.getReturnCode() == 1 ? null : dialog.getCurrentNote();
    }
}

