/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.handlers;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IHasMetaRep;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.note.INote;
import edu.mit.story.core.meta.note.Note;
import edu.mit.story.core.meta.note.NoteMetaRep;
import edu.mit.story.core.model.change.AddMetadataChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveMetadataChange;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.dialogs.EditNoteDialog;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class EditNoteHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IMetaDesc oldNote;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IMetaDesc metadesc = SelectionUtils.extractSingle(sel, IMetaDesc.class);
        if (!NoteMetaRep.getInstance().isType((IHasMetaRep)metadesc)) {
            return null;
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        String newNote = EditNoteDialog.editNote(shell, ((INote)(oldNote = metadesc).getData()).getNote());
        if (newNote == null) {
            return null;
        }
        IStoryEditor editor = (IStoryEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IDesc desc = editor.getStoryModel().getData().getDescription(metadesc.getDescriptionID());
        MetaDesc newMetadesc = new MetaDesc((IMetaRep)NoteMetaRep.getInstance(), desc, (IMetaData)new Note(newNote));
        AddMetadataChange change = new AddMetadataChange((IMetaDesc)newMetadesc);
        change = new CompositeModelChange(new IModelChange[]{new RemoveMetadataChange(metadesc), change});
        editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        return null;
    }
}

