/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.helpers;

import edu.mit.story.core.manager.CreatableManager;
import edu.mit.story.core.manager.IHasRepManager;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.helpers.IHelperDescriptor;
import edu.mit.story.ui.helpers.IHelperPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HelperPageManager<H extends IHelperPage, D extends IHelperDescriptor<H>>
extends CreatableManager<H, D>
implements IHasRepManager<H, D> {
    private final String extensionName;
    protected Map<IRep, List<D>> repMap = new HashMap<IRep, List<D>>();

    public HelperPageManager(String extensionName) {
        if (extensionName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.extensionName = extensionName;
    }

    protected boolean doInit() {
        this.repMap.clear();
        D d = null;
        for (IConfigurationElement iConfigurationElement : HelperPageManager.getElements((String)"edu.mit.story.ui.helpers", (String)this.extensionName)) {
            try {
                d = this.makeDescriptor(iConfigurationElement);
            }
            catch (Exception ex) {
                Status status = new Status(2, StoryUIPlugin.getDefault().getID(), "problem with helper declaration " + iConfigurationElement.getAttribute("id"), (Throwable)ex);
                StoryUIPlugin.getDefault().getLog().log((IStatus)status);
                continue;
            }
            if (d == null) continue;
            this.registerDescriptor(d);
        }
        for (Map.Entry entry : this.repMap.entrySet()) {
            entry.setValue(Collections.unmodifiableList(new ArrayList((Collection)entry.getValue())));
        }
        return true;
    }

    protected abstract D makeDescriptor(IConfigurationElement var1);

    protected boolean registerDescriptor(D desc) {
        boolean success = super.registerDescriptor(desc);
        List<D> ds = this.repMap.get(desc.getRep());
        if (ds == null) {
            ds = new LinkedList<D>();
            this.repMap.put(desc.getRep(), ds);
        }
        if (!ds.contains(desc)) {
            ds.add(desc);
        }
        return success;
    }

    public List<D> getDescriptors(IRep rep) {
        this.checkInit();
        return this.repMap.get(rep);
    }
}

