/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.ui.StoryUIMessages;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InputValueGroup<T>
extends Composite
implements INotifyingMessageProvider {
    private final String inputName;
    private final String inputDesc;
    private final T initialValue;
    private final IValidator<T> validator;
    private final ChangeNotifier notifier = new ChangeNotifier();
    private int messageCode = 0;
    private String message = "";
    private Label nameLabel;
    private Label descLabel;
    private Control inputWidget;

    public InputValueGroup(Composite parent) {
        this(parent, StoryUIMessages.InputGroup_label_default);
    }

    public InputValueGroup(Composite parent, String label) {
        this(parent, label, null);
    }

    public InputValueGroup(Composite parent, String label, String desc) {
        this(parent, label, desc, null, null);
    }

    public InputValueGroup(Composite parent, String label, String desc, T initialValue, IValidator<T> validator) {
        super(parent, 0);
        this.validator = validator;
        this.inputName = label;
        this.inputDesc = desc;
        this.initialValue = initialValue;
    }

    public abstract T getValue();

    public abstract void setValue(T var1);

    protected abstract Control getInputWidget();

    protected void createContents() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        if (this.inputName == null) {
            layout.numColumns = 1;
        } else {
            layout.numColumns = 2;
            this.nameLabel = new Label((Composite)this, 0);
            this.nameLabel.setText(this.inputName);
        }
        this.inputWidget = this.getInputWidget();
        if (this.inputDesc != null) {
            new Label((Composite)this, 0);
            this.descLabel = new Label((Composite)this, 0);
            this.descLabel.setText(this.inputDesc);
        }
        this.setValue(this.initialValue);
    }

    public boolean setFocus() {
        return this.inputWidget.setFocus();
    }

    public T getInitialValue() {
        return this.initialValue;
    }

    public boolean validate() {
        if (this.validator == null) {
            return true;
        }
        IMessageProvider result = this.validator.validate(this.getValue());
        this.message = result == null ? "" : result.getMessage();
        int n = this.messageCode = result == null ? 0 : result.getMessageType();
        return result == null;
    }

    public String getMessage() {
        return this.message;
    }

    public int getMessageType() {
        return this.messageCode;
    }

    public void notifyChangeListeners(Object source) {
        this.notifier.notifyChangeListeners((Object)this);
    }

    public void addChangeListener(ChangeListener listener) {
        this.notifier.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.notifier.removeChangeListener(listener);
    }

    public void allowNotifications() {
        this.notifier.allowNotifications();
    }

    public void suppressNotifications() {
        this.notifier.suppressNotifications();
    }
}

