/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.datamodel.BatchPairModel;
import edu.mit.story.core.datamodel.IBatchPairModel;
import edu.mit.story.core.merge.IMergeModel;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.controllers.BatchPairController;
import edu.mit.story.ui.controllers.IBatchPairController;
import edu.mit.story.ui.ops.MergeBatchOperation;
import edu.mit.story.ui.wizards.page.ResourcePairsPage;
import edu.mit.story.ui.wizards.page.TransferRepsPage;
import edu.mit.story.ui.wizards.page.TransferTargetsPage;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.DirectoryDialog;

public class MergeBatchWizard
extends Wizard {
    protected final IBatchPairController<IBatchPairModel> controller;
    protected final IMergeModel mergeModel;
    private static String previouslyBrowsedDirectory = "";
    protected TransferTargetsPage pageOne;
    protected ResourcePairsPage pageTwo;
    protected TransferRepsPage pageThree;

    public MergeBatchWizard(ISelection selection, IMergeModel mergeModel, String title) {
        this.setWindowTitle("Merge Story Files: " + title);
        this.setNeedsProgressMonitor(true);
        if (mergeModel == null) {
            throw new NullPointerException();
        }
        IResource source = null;
        IResource target = null;
        IStructuredSelection struct = SelectionUtils.castAsStructuredSelection(selection);
        if (struct != null) {
            for (Object obj : struct.toList()) {
                if (!(obj instanceof IResource)) continue;
                IResource res = (IResource)obj;
                if (source == null) {
                    source = res;
                    continue;
                }
                target = res;
                break;
            }
        }
        BatchPairModel model = new BatchPairModel();
        if (source != null) {
            model.setSource(source.getRawLocation().toFile());
        }
        if (target != null) {
            model.setTarget(target.getRawLocation().toFile());
        }
        model.setSourceTag(mergeModel.getSourceTag());
        model.setTargetTag(mergeModel.getTargetTag());
        this.controller = new BatchPairController<BatchPairModel>(model);
        this.mergeModel = mergeModel;
    }

    public void addPages() {
        this.pageOne = new TransferTargetsPage(this.controller){

            protected File selectFile(String title, boolean save) {
                DirectoryDialog dialog = new DirectoryDialog(this.getShell());
                dialog.setMessage("Select the " + title + " folder");
                String dirName = this.outputBox.getText().trim();
                if (dirName.length() == 0) {
                    dirName = previouslyBrowsedDirectory;
                }
                if (dirName.length() == 0) {
                    dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
                } else {
                    File path = new File(dirName);
                    if (path.exists()) {
                        dialog.setFilterPath(new Path(dirName).toOSString());
                    }
                }
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    previouslyBrowsedDirectory = selectedDirectory;
                }
                return new File(selectedDirectory);
            }
        };
        this.addPage((IWizardPage)this.pageOne);
        this.pageTwo = new ResourcePairsPage(this.controller);
        this.addPage((IWizardPage)this.pageTwo);
        this.pageThree = new TransferRepsPage(this.mergeModel);
        this.addPage((IWizardPage)this.pageThree);
    }

    public boolean performFinish() {
        MergeBatchOperation op = new MergeBatchOperation(this.pageThree.getModel(), (IBatchPairModel)this.controller.getModel());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            Status status = new Status(4, "edu.mit.story.core", "Transfer failed", (Throwable)e);
            StoryPlugin.getDefault().getLog().log((IStatus)status);
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

