/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards.page;

import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.widgets.ConfigurationWidget;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepConfigPage
extends WizardPage
implements ChangeListener {
    public static final String NAME = StringUtils.getClassName(RepConfigPage.class);
    private Composite widgetParent;
    private MessageProviderManager manager;
    private Set<IRep> pageReps = new TreeSet<IRep>();
    private Map<IRep, ConfigurationWidget> widgets = new TreeMap<IRep, ConfigurationWidget>();

    public RepConfigPage() {
        super(NAME);
        this.setTitle(StoryUIMessages.WIZARD_PAGE_ConfigureReps_title);
        this.setDescription(StoryUIMessages.WIZARD_PAGE_ConfigureReps_description);
        this.setImageDescriptor(StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("wizban/factory_wiz.gif"));
        Message message = new Message(this.getDescription(), 0);
        this.manager = new MessageProviderManager((IMessageProvider)message, (ChangeListener)this);
    }

    public void createControl(Composite parent) {
        this.widgetParent = new Composite(parent, 0);
        this.widgetParent.setLayoutData((Object)new GridData(4, 0, true, false));
        this.widgetParent.setLayout((Layout)new GridLayout());
        this.setControl((Control)this.widgetParent);
        this.updateWidgets();
    }

    protected void updateWidgets() {
        Control[] controlArray = this.widgetParent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        for (ConfigurationWidget widget : this.widgets.values()) {
            this.manager.remove((INotifyingMessageProvider)widget);
        }
        this.widgets.clear();
        for (IRep rep : this.pageReps) {
            ConfigurationWidget widget;
            widget = new ConfigurationWidget(this.widgetParent, rep.getConfigurationDescriptor());
            widget.getControl().setLayoutData((Object)new GridData(4, 0, true, false));
            this.widgets.put(rep, widget);
            this.manager.add((INotifyingMessageProvider)widget);
        }
        if (this.widgets.size() == 0) {
            Label label = new Label(this.widgetParent, 0);
            label.setText("No configurable representations");
        }
        this.widgetParent.layout(true, true);
        this.stateChanged(null);
    }

    public void setRepresentations(Set<IRep> reps) {
        boolean changed = this.pageReps.retainAll(reps);
        for (IRep rep : reps) {
            if (rep.getConfigurationDescriptor() == null) continue;
            changed |= this.pageReps.add(rep);
        }
        if (changed) {
            this.updateWidgets();
        }
    }

    public Map<IRep, IConfiguration> getConfigurations() {
        HashMap<IRep, IConfiguration> result = new HashMap<IRep, IConfiguration>(this.widgets.size());
        for (Map.Entry<IRep, ConfigurationWidget> entry : this.widgets.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getConfiguration());
        }
        return result;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.setPageComplete(this.manager.getMessageType() != 3);
        this.setMessage(this.manager.getMessage(), this.manager.getMessageType());
    }
}

