/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.build;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.DescMultiSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.core.descriptor.Registered;
import edu.mit.story.core.mappers.DescriptionMapper;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IRep;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryProblem
extends Registered
implements IStoryProblem {
    private IRep rep;
    private int severity = 2;
    private String buildRuleID = null;
    private String data = null;
    private String check = null;
    private IDescMultiSet descs = null;
    private IHasPosition p;

    public StoryProblem(IRep rep, String buildRuleID) {
        this.setRep(rep);
        this.setBuildRuleID(buildRuleID);
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public int getOffset() {
        return this.p == null ? -1 : this.p.getOffset();
    }

    @Override
    public int getLength() {
        return this.p == null ? -1 : this.p.getLength();
    }

    @Override
    public int getRightOffset() {
        return this.p == null ? -1 : this.p.getRightOffset();
    }

    @Override
    public IDescMultiSet getDescs() {
        return this.descs;
    }

    @Override
    public IRep getRep() {
        return this.rep;
    }

    @Override
    public String getCheck() {
        return this.check;
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public String getBuildRuleID() {
        return this.buildRuleID;
    }

    public void setRep(IRep rep) {
        this.rep = rep;
    }

    public void setSeverity(int severity) {
        StoryProblem.checkSeverity(severity);
        this.severity = severity;
    }

    public void setPosition(IHasPosition p) {
        this.setPosition(p.getOffset(), p.getLength());
    }

    public void setPosition(int offset, int length) {
        this.p = offset < 0 || length < 0 ? null : new SimplePosition(offset, length);
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setCheck(String check) {
        if (check != null && check.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.check = check;
    }

    public void setBuildRuleID(String id) {
        this.buildRuleID = id;
    }

    public void setDescs(Collection<? extends IDesc> descs) {
        this.descs = new DescMultiSet(descs);
    }

    public static void markProblem(IResource resource, IStoryProblem problem) {
        try {
            IMarker marker = resource.createMarker("edu.mit.story.core.marker.problem");
            marker.setAttribute("generatedBy", (Object)problem.getBuildRuleID());
            marker.setAttribute("severity", problem.getSeverity());
            marker.setAttribute("message", (Object)problem.getDescription());
            String offset = Integer.toString(problem.getOffset());
            StringBuilder sb = new StringBuilder();
            sb.append("offset ");
            int i = 0;
            while (i < 5 - offset.length()) {
                sb.append('0');
                ++i;
            }
            sb.append(offset);
            marker.setAttribute("location", (Object)sb.toString());
            marker.setAttribute("charStart", problem.getOffset());
            marker.setAttribute("charEnd", problem.getRightOffset());
            marker.setAttribute("name", (Object)problem.getName());
            marker.setAttribute("repID", problem.getRep() == null ? null : problem.getRep().getID());
            marker.setAttribute("problemID", (Object)problem.getID());
            marker.setAttribute("data", (Object)problem.getData());
            marker.setAttribute("descIDs", (Object)DescriptionMapper.toValueStatic(problem.getDescs()));
            marker.setAttribute("check", (Object)problem.getCheck());
        }
        catch (CoreException e) {
            Status status = new Status(4, "edu.mit.story.core", "", (Throwable)e);
            StoryPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public static StoryProblem toProblem(IMarker marker, IDescMultiSet data) {
        try {
            if (!marker.isSubtypeOf("edu.mit.story.core.marker.problem")) {
                return null;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        StoryProblem p = new StoryProblem(null, null);
        p.setBuildRuleID(marker.getAttribute("generatedBy", null));
        p.setDescription(marker.getAttribute("message", null));
        p.setSeverity(marker.getAttribute("severity", 2));
        int offset = marker.getAttribute("charStart", -1);
        int rightOffset = marker.getAttribute("charEnd", -1);
        p.setPosition(offset, rightOffset - offset);
        p.setName(marker.getAttribute("name", null));
        p.setID(marker.getAttribute("problemID", null));
        p.setData(marker.getAttribute("data", null));
        p.setCheck(marker.getAttribute("check", null));
        IRep rep = StoryPlugin.getDefault().getRepManager().getRep(marker.getAttribute("repID", null));
        p.setRep(rep);
        String ids = marker.getAttribute("descIDs", "");
        List<IDesc> ds = DescriptionMapper.toObjectsStatic(ids, data);
        if (!ds.isEmpty()) {
            p.setDescs(ds);
        }
        return p;
    }

    public static void checkSeverity(int severity) {
        if (!StoryProblem.isValidSeverity(severity)) {
            throw new IllegalArgumentException();
        }
    }

    public static boolean isValidSeverity(int severity) {
        if (severity == 2) {
            return true;
        }
        if (severity == 1) {
            return true;
        }
        return severity == 0;
    }
}

