/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.measure;

import edu.mit.story.core.measure.IResult;
import edu.mit.story.core.measure.ITargetExtractor;
import edu.mit.story.core.measure.Result;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileExtractor
implements ITargetExtractor<IFile> {
    private final Pattern filenamePattern;

    public FileExtractor(String extension) {
        this.filenamePattern = Pattern.compile(".*\\Q." + extension + "\\E");
    }

    @Override
    public List<IFile> getTargets(IResource r, List<IResult> results) {
        if (r == null) {
            throw new NullPointerException();
        }
        if (results == null) {
            results = new LinkedList<IResult>();
        }
        LinkedList<IFile> files = new LinkedList<IFile>();
        LinkedList<IResource> queue = new LinkedList<IResource>();
        queue.add(r);
        HashSet<IResource> beenHere = new HashSet<IResource>();
        while ((r = (IResource)queue.poll()) != null) {
            if (!beenHere.add(r)) continue;
            if (!r.isAccessible()) {
                results.add(new Result(r, "Resource not accessible", null));
                continue;
            }
            switch (r.getType()) {
                case 1: {
                    if (this.filenamePattern.matcher(r.getName()).matches()) {
                        files.add((IFile)r);
                        break;
                    }
                    results.add(new Result(r, "Ignoring this file - doesn't end with .txt extension", null));
                    break;
                }
                case 2: 
                case 4: {
                    try {
                        queue.addAll(Arrays.asList(((IContainer)r).members()));
                        break;
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return files;
    }
}

