/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model;

import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.IHasRefresh;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshListener
implements IModelListener {
    private final IHasRefresh target;
    private final IRep rep;
    private final IFlag<?> flag;

    public RefreshListener(IHasRefresh target) {
        this(target, null);
    }

    public RefreshListener(IHasRefresh target, IRep rep) {
        this(target, rep, null);
    }

    public RefreshListener(IHasRefresh target, IRep rep, IFlag<?> flag) {
        if (target == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.rep = rep;
        this.flag = flag;
    }

    @Override
    public void modelChanged(StoryChangeEvent e) {
        if (this.target != null && this.shouldRefresh(e)) {
            this.target.refresh();
        }
    }

    protected boolean shouldRefresh(StoryChangeEvent e) {
        if (this.rep == null) {
            return true;
        }
        Change change = e.getChange(this.rep);
        if (change == null) {
            return false;
        }
        return this.flag == null ? change != null : change.changed(this.flag);
    }
}

