/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.DescMultiSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaDataMap;
import edu.mit.story.core.meta.MetaDataMap;
import edu.mit.story.core.model.ConsistentRestrictedMultiSet;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.ConsistentRepSet;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryData
extends ConsistentRestrictedMultiSet
implements IStoryData {
    private static final long serialVersionUID = -1820773542397814836L;
    protected final SortedMap<IRep, IConfiguration> configMap = new TreeMap<IRep, IConfiguration>();
    protected final IMetaDataMap metadata = new MetaDataMap();

    @Override
    protected SortedMap<IRep, IDescSet> createDescriptionMap(Collection<? extends IDesc> c) {
        TreeMap<IRep, IDescSet> result = new TreeMap<IRep, IDescSet>();
        if (c == null) {
            return result;
        }
        DescMultiSet hidden = new DescMultiSet();
        hidden.addAll(c);
        Iterator<IDescSet> i = hidden.descSetIterator();
        while (i.hasNext()) {
            IDescSet descSet = i.next();
            result.put(descSet.getRep(), descSet);
        }
        return result;
    }

    @Override
    protected IRepSet createSupportSet(Collection<? extends IRep> reps) {
        return reps == null ? new ConsistentRepSet() : new ConsistentRepSet(reps);
    }

    @Override
    public IConfiguration getConfiguration(IRep rep) {
        this.check(rep);
        return (IConfiguration)this.configMap.get(rep);
    }

    @Override
    public void setConfiguration(IConfiguration newConfig) {
        if (newConfig == null) {
            return;
        }
        IRep rep = StoryPlugin.getDefault().getRepManager().getRep(newConfig.getID());
        this.check(rep);
        IConfigDescriptor desc = rep.getConfigurationDescriptor();
        if (desc == null) {
            return;
        }
        if (desc.validate(newConfig)) {
            IConfiguration config = (IConfiguration)this.configMap.get(rep);
            config.configure(newConfig);
        }
    }

    @Override
    public boolean addSupport(IRep rep) {
        IConfigDescriptor desc;
        boolean result = super.addSupport(rep);
        if (result && (desc = rep.getConfigurationDescriptor()) != null) {
            this.configMap.put(rep, desc.createDefault());
        }
        return result;
    }

    @Override
    public boolean removeSupport(IRep rep) {
        boolean result = super.removeSupport(rep);
        if (result) {
            this.configMap.remove(rep);
        }
        return result;
    }

    @Override
    public IMetaDataMap getMetadata() {
        return this.metadata;
    }
}

