/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.util.Immutable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Change
implements Immutable {
    private final IHasPositionSet<IHasPosition> allChanges;
    private final Map<IFlag, IHasPositionSet> hiddenMap;
    private final Map<IFlag, IHasPositionSet> changeMap;

    public Change(Change ... changes) {
        this(Arrays.asList(changes));
    }

    public Change(Collection<? extends Change> changes) {
        if (changes.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.hiddenMap = new IdentityHashMap<IFlag, IHasPositionSet>();
        for (Change change : changes) {
            for (Map.Entry<IFlag, IHasPositionSet> entry : change.changeMap.entrySet()) {
                HasPositionSet set = this.hiddenMap.get(entry.getKey());
                if (set == null) {
                    set = new HasPositionSet();
                    this.hiddenMap.put(entry.getKey(), set);
                }
                set.addAll(entry.getValue());
            }
        }
        this.changeMap = Collections.unmodifiableMap(this.hiddenMap);
        this.allChanges = this.makeAllChanges();
    }

    public <T extends IHasPosition> Change(IFlag<T> flag, T ... changedRegions) {
        this(flag, (Collection<? extends T>)Arrays.asList(changedRegions));
    }

    public <T extends IHasPosition> Change(IFlag<T> flag, Collection<? extends T> changedRegions) {
        if (flag == null) {
            throw new IllegalArgumentException();
        }
        if (changedRegions.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (flag instanceof IFlag.IFlagSet) {
            IFlag.IFlagSet flagSet = (IFlag.IFlagSet)flag;
            this.hiddenMap = new IdentityHashMap<IFlag, IHasPositionSet>(flagSet.size());
            for (IFlag subFlag : flagSet) {
                HasPositionSet<? extends T> set = new HasPositionSet<T>(changedRegions);
                this.hiddenMap.put(subFlag, set);
            }
        } else {
            this.hiddenMap = new IdentityHashMap<IFlag, IHasPositionSet>(1);
            HasPositionSet<? extends T> set = new HasPositionSet<T>(changedRegions);
            this.hiddenMap.put(flag, set);
        }
        this.changeMap = Collections.unmodifiableMap(this.hiddenMap);
        this.allChanges = this.makeAllChanges();
    }

    protected IHasPositionSet<IHasPosition> makeAllChanges() {
        HasPositionSet<IHasPosition> hidden = new HasPositionSet<IHasPosition>();
        for (IHasPositionSet sets : this.changeMap.values()) {
            hidden.addAll(sets);
        }
        return hidden;
    }

    public boolean changed(IFlag<?> flag) {
        if (flag instanceof IFlag.IFlagSet) {
            IFlag.IFlagSet flagSet = (IFlag.IFlagSet)flag;
            for (IFlag subflag : flagSet) {
                if (!this.changeMap.containsKey(subflag)) continue;
                return true;
            }
            return false;
        }
        return this.changeMap.containsKey(flag);
    }

    public IHasPositionSet<? extends IHasPosition> getChanges() {
        return this.allChanges;
    }

    public <T extends IHasPosition> IHasPositionSet<T> getChanges(IFlag<T> flag) {
        HasPositionSet result = this.changeMap.get(flag);
        if (result == null && flag instanceof IFlag.IFlagSet) {
            IFlag.IFlagSet flagSet = (IFlag.IFlagSet)flag;
            for (IFlag subflag : flagSet) {
                IHasPositionSet subResult = this.changeMap.get(subflag);
                if (subResult == null) continue;
                if (result == null) {
                    result = new HasPositionSet();
                }
                result.addAll(subResult);
            }
            if (result != null) {
                this.hiddenMap.put(flag, result);
            }
        }
        return result;
    }

    public String toString() {
        return "Change:" + this.hiddenMap.toString();
    }
}

