/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepManager;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.util.ImmutableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepManager
implements IRepManager {
    private Object syncInit = new Object();
    private boolean isInitialized = false;
    private List<IRep> descList;
    SortedMap<String, IRep> fRepMap = null;
    IRepSet fReps = null;
    IRepSet fRootReps = null;
    IRepSet fDefaultReps = null;
    IRepSet fRequiredReps = null;
    Set<IRep> fRegistryDefaults = new HashSet<IRep>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Object object = this.syncInit;
        synchronized (object) {
            if (this.isInitialized) {
                return;
            }
            this.fRepMap = new TreeMap<String, IRep>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("edu.mit.story.core.representations");
            if (point == null) {
                String message = String.valueOf(StoryMessages.MSG_ERR_MissingExtensionPoint) + ": " + "edu.mit.story.core.representations";
                Status status = new Status(4, StoryPlugin.getDefault().getID(), 0, message, null);
                StoryPlugin.getDefault().getLog().log((IStatus)status);
                return;
            }
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    try {
                        if (element.getName().equals("representation")) {
                            IRep rep = (IRep)element.createExecutableExtension("class");
                            String id = element.getAttribute("id");
                            String name = element.getAttribute("name");
                            String desc = element.getAttribute("description");
                            String markerID = element.getAttribute("markerID");
                            HashMap<IRep.Form, String> forms = new HashMap<IRep.Form, String>();
                            IRep.Form[] formArray = IRep.Form.values();
                            int n5 = formArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IRep.Form form = formArray[n6];
                                String value = element.getAttribute(form.getKey());
                                if (value != null) {
                                    forms.put(form, value);
                                }
                                ++n6;
                            }
                            if (!(id.equals("") | name.equals("") | desc.equals(""))) {
                                rep.setID(id);
                                rep.setName(name);
                                rep.setDescription(desc);
                                rep.setMarkerID(markerID);
                                rep.setDescriptionName(forms);
                                this.fRepMap.put(rep.getID(), rep);
                            }
                        }
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, StoryPlugin.getDefault().getID(), 0, e.getLocalizedMessage(), (Throwable)e);
                        StoryPlugin.getDefault().getLog().log((IStatus)status);
                    }
                    ++n4;
                }
                ++n2;
            }
            this.isInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInitialized() {
        Object object = this.syncInit;
        synchronized (object) {
            return this.isInitialized;
        }
    }

    @Override
    public List<IRep> getDescriptors() {
        if (this.descList == null) {
            this.descList = Collections.unmodifiableList(new ArrayList<IRep>(this.getSupported()));
        }
        return this.descList;
    }

    @Override
    public IRep getRep(String id) {
        if (id == null) {
            return null;
        }
        return (IRep)this.fRepMap.get(id);
    }

    @Override
    public IRep getDescriptor(String id) {
        return this.getRep(id);
    }

    @Override
    public IRepSet getSupported() {
        if (this.fReps == null) {
            this.fReps = new RepSet(this.fRepMap.values());
        }
        return new RepSet(this.fReps);
    }

    @Override
    public IRepSet getRequired() {
        if (this.fRequiredReps == null) {
            this.fRequiredReps = new RepSet();
            this.fRequiredReps.add(CharRep.getInstance());
        }
        return new RepSet(this.fRequiredReps);
    }

    @Override
    public boolean supports(IRep rep) {
        return this.fReps.supports(rep);
    }

    @Override
    public boolean supportsAll(Collection<? extends IRep> reps) {
        return this.fReps.supportsAll(reps);
    }

    @Override
    public Iterator<IRep> repIterator() {
        return new ImmutableIterator<IRep>(this.fReps.iterator());
    }

    @Override
    public int repSize() {
        return this.fReps.size();
    }
}

